/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.internet;

import java.util.Objects;

public final class UrlHost {
    private static final String DELIMITER = ".";
    private static final String PREFIX_VALUE = "www";
    private final String wwwPrefix;
    private final String rootDomain;
    private final String topLevelDomain;

    public UrlHost(String rootDomain, String topLevelDomain, boolean withoutPrefix) {
        this.validateDomains(rootDomain, topLevelDomain);
        this.rootDomain = rootDomain;
        this.topLevelDomain = topLevelDomain;
        this.wwwPrefix = withoutPrefix ? "" : PREFIX_VALUE;
    }

    private void validateDomains(String rootDomain, String topLevelDomain) {
        this.validateNotEmpty(rootDomain, "root domain");
        this.validateNotEmpty(topLevelDomain, "top level domain");
    }

    private void validateNotEmpty(String argument, String name) {
        if (argument == null || argument.isEmpty()) {
            throw new IllegalArgumentException("The " + name + " can't be null or empty");
        }
    }

    public String getRootDomain() {
        return this.rootDomain;
    }

    public String getTopLevelDomain() {
        return this.topLevelDomain;
    }

    public String toString() {
        if (this.wwwPrefix.isEmpty()) {
            return this.rootDomain + DELIMITER + this.topLevelDomain;
        }
        return this.wwwPrefix + DELIMITER + this.rootDomain + DELIMITER + this.topLevelDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlHost urlHost = (UrlHost)o;
        return Objects.equals(this.wwwPrefix, urlHost.wwwPrefix) && Objects.equals(this.rootDomain, urlHost.rootDomain) && Objects.equals(this.topLevelDomain, urlHost.topLevelDomain);
    }

    public int hashCode() {
        return Objects.hash(this.wwwPrefix, this.rootDomain, this.topLevelDomain);
    }
}

