/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.internet;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringSanitizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class EmailBuilder {
    public static final String DOMAIN_KEY = "#{internet.email_domain}";
    public static final String SAFE_DOMAIN_KEY = "#{internet.email_safe_domains}";
    public static final String SUB_ADDRESS_KEY = "#{internet.email_sub_address}";
    private final Dummy4j dummy4j;
    private String customDomain;
    private String customLocalPart;
    private List<String> customSubAddresses = new ArrayList<String>();
    private boolean randomizeSubAddress;
    private String localPartDelimiter = ".";
    private boolean sanitize = true;

    public EmailBuilder(Dummy4j dummy4j) {
        this.dummy4j = dummy4j;
    }

    public EmailBuilder safe() {
        this.customDomain = this.dummy4j.expressionResolver().resolve(SAFE_DOMAIN_KEY);
        return this;
    }

    public EmailBuilder withDomain(String customDomain) {
        this.customDomain = customDomain;
        return this;
    }

    public EmailBuilder withLocalPart(String localPart) {
        this.customLocalPart = localPart;
        return this;
    }

    public EmailBuilder withLocalPartDelimiter(String delimiter) {
        this.localPartDelimiter = delimiter;
        return this;
    }

    public EmailBuilder withRandomSubAddress() {
        this.randomizeSubAddress = true;
        this.customSubAddresses = new ArrayList<String>();
        return this;
    }

    public EmailBuilder withSubAddresses(String ... customSubAddresses) {
        this.randomizeSubAddress = false;
        this.customSubAddresses = Arrays.asList(customSubAddresses);
        return this;
    }

    public EmailBuilder notSanitized() {
        this.sanitize = false;
        return this;
    }

    public String build() {
        return this.getFullLocalPart() + "@" + this.getDomain();
    }

    private String getFullLocalPart() {
        String localPart = this.getLocalPart();
        localPart = localPart + this.processSubAddresses(this.getSubAddresses());
        if (this.sanitize) {
            localPart = StringSanitizer.sanitizeForEmail(localPart);
        }
        return localPart;
    }

    private String getLocalPart() {
        if (this.customLocalPart != null) {
            return this.customLocalPart;
        }
        return this.getRandomLocalPart();
    }

    private String getRandomLocalPart() {
        String firstName = this.dummy4j.name().firstName().toLowerCase(Locale.ENGLISH);
        String lastName = this.dummy4j.name().lastName().toLowerCase(Locale.ENGLISH);
        return firstName + this.localPartDelimiter + lastName;
    }

    private String processSubAddresses(List<String> subAddresses) {
        if (subAddresses.isEmpty()) {
            return "";
        }
        return "+" + String.join((CharSequence)"+", subAddresses);
    }

    private List<String> getSubAddresses() {
        if (this.randomizeSubAddress) {
            return Collections.singletonList(this.dummy4j.expressionResolver().resolve(SUB_ADDRESS_KEY));
        }
        return this.customSubAddresses;
    }

    private String getDomain() {
        if (this.customDomain != null) {
            return this.customDomain;
        }
        return this.dummy4j.expressionResolver().resolve(DOMAIN_KEY);
    }

    public String toString() {
        return "EmailBuilder{customDomain='" + this.customDomain + '\'' + ", customLocalPart='" + this.customLocalPart + '\'' + ", customSubAddresses=" + this.customSubAddresses + ", randomizeSubAddress=" + this.randomizeSubAddress + ", localPartDelimiter='" + this.localPartDelimiter + '\'' + ", sanitize=" + this.sanitize + '}';
    }
}

