/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.namenumber;

import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.namenumber.BasicIsniProvider;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringFormatter;

public class OrcidBuilder {
    private static final int NUMBER_OF_CHARS_PER_GROUP = 4;
    private static final String DEFAULT_SEPARATOR = "-";
    private static final String DEFAULT_URL_PREFIX = "https://orcid.org/";
    private final BasicIsniProvider isniProvider;
    private String urlPrefix = "";

    public OrcidBuilder(BasicIsniProvider isniProvider) {
        this.isniProvider = isniProvider;
    }

    public OrcidBuilder asUrl() {
        this.urlPrefix = DEFAULT_URL_PREFIX;
        return this;
    }

    public OrcidBuilder asNumber() {
        this.urlPrefix = "";
        return this;
    }

    public String build() {
        String orcid = this.isniProvider.provide();
        return this.urlPrefix + StringFormatter.insertEveryNthCharacter(orcid, DEFAULT_SEPARATOR, 4);
    }
}

