/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.namenumber;

import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.namenumber.BasicIsniProvider;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringFormatter;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringValidator;
import dev.codesoapbox.dummy4j.exceptions.IvalidIsniParameterException;

public class IsniBuilder {
    private static final String DEFAULT_SEPARATOR = " ";
    private static final String DEFAULT_URL_PREFIX = "https://isni.org/isni/";
    private static final String FORMAT_IN_URL_EXCEPTION_MESSAGE = "ISNI can't be both formatted and used in an url";
    private static final int NUMBER_OF_CHARS_PER_GROUP = 4;
    private final BasicIsniProvider isniProvider;
    private String urlPrefix = "";
    private String separator = "";

    public IsniBuilder(BasicIsniProvider isniProvider) {
        this.isniProvider = isniProvider;
    }

    public IsniBuilder withSeparator() {
        if (!StringValidator.isNullOrEmpty(this.urlPrefix)) {
            throw new IvalidIsniParameterException(FORMAT_IN_URL_EXCEPTION_MESSAGE);
        }
        this.separator = DEFAULT_SEPARATOR;
        return this;
    }

    public IsniBuilder withoutSeparator() {
        this.separator = "";
        return this;
    }

    public IsniBuilder asUrl() {
        if (!this.separator.isEmpty()) {
            throw new IvalidIsniParameterException(FORMAT_IN_URL_EXCEPTION_MESSAGE);
        }
        this.urlPrefix = DEFAULT_URL_PREFIX;
        return this;
    }

    public IsniBuilder asNumber() {
        this.urlPrefix = "";
        return this;
    }

    public String build() {
        String isni = this.isniProvider.provide();
        if (this.separator.isEmpty()) {
            return this.urlPrefix + isni;
        }
        return StringFormatter.insertEveryNthCharacter(isni, DEFAULT_SEPARATOR, 4);
    }
}

