/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber;

import dev.codesoapbox.dummy4j.dummies.shared.math.NumberValidator;
import dev.codesoapbox.dummy4j.exceptions.InvalidIsmnParameterException;
import dev.codesoapbox.dummy4j.exceptions.InvalidRangeException;
import dev.codesoapbox.dummy4j.exceptions.ValueOutOfRangeException;
import java.util.Objects;

final class IsmnRegistrantRange {
    private static final int MIN_REGISTRANT = 0;
    private int min;
    private int max;

    private IsmnRegistrantRange() {
    }

    static IsmnRegistrantRange from(int min, int max) {
        IsmnRegistrantRange.validateRange(min, max);
        IsmnRegistrantRange range = new IsmnRegistrantRange();
        range.min = min;
        range.max = max;
        return range;
    }

    private static void validateRange(int min, int max) {
        try {
            NumberValidator.inRange(min, 0.0f, max);
        }
        catch (InvalidRangeException | ValueOutOfRangeException e) {
            String message = String.format("Invalid registrant range from %d to %d", min, max);
            throw new InvalidIsmnParameterException(message, e);
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsmnRegistrantRange that = (IsmnRegistrantRange)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return "IsmnRegistrantRange{min=" + this.min + ", max=" + this.max + '}';
    }
}

