/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber.Ismn;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber.IsmnRegistrantRange;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber.IsmnValidator;
import dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas.ModTenFormula;
import dev.codesoapbox.dummy4j.dummies.shared.string.Padding;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class IsmnBuilder {
    static final String ISMN_SEPARATOR_KEY = "#{identifier.ismn.separator}";
    static final List<IsmnRegistrantRange> REGISTRANT_RANGES = Arrays.asList(IsmnRegistrantRange.from(0, 99), IsmnRegistrantRange.from(1000, 3999), IsmnRegistrantRange.from(40000, 69999), IsmnRegistrantRange.from(700000, 899999), IsmnRegistrantRange.from(9000000, 9999999));
    private static final Integer ISMN_BASE_LENGTH = 8;
    private final Dummy4j dummy4j;
    private final ModTenFormula modTenFormula;
    private final IsmnValidator validator;
    private List<String> separators;
    private List<String> registrants;

    public IsmnBuilder(Dummy4j dummy4j, ModTenFormula modTenFormula, IsmnValidator ismnValidator) {
        this.dummy4j = dummy4j;
        this.modTenFormula = modTenFormula;
        this.validator = ismnValidator;
    }

    public IsmnBuilder withRandomRegistrant() {
        this.registrants = Collections.emptyList();
        return this;
    }

    public IsmnBuilder withRandomRegistrant(String ... registrants) {
        Arrays.stream(registrants).forEach(this.validator::testForInvalidRegistrant);
        this.registrants = Arrays.asList(registrants);
        return this;
    }

    public IsmnBuilder withRegistrant(String registrant) {
        this.validator.testForInvalidRegistrant(registrant);
        this.registrants = Collections.singletonList(registrant);
        return this;
    }

    public IsmnBuilder withRandomSeparator() {
        this.separators = Collections.emptyList();
        return this;
    }

    public IsmnBuilder withRandomSeparator(String ... separators) {
        this.separators = Arrays.asList(separators);
        return this;
    }

    public IsmnBuilder withSeparator(String separator) {
        this.separators = Collections.singletonList(separator);
        return this;
    }

    public IsmnBuilder withoutSeparator() {
        this.separators = Collections.singletonList("");
        return this;
    }

    public Ismn build() {
        String registrant = this.resolveRegistrant();
        String item = this.dummy4j.number().digits(ISMN_BASE_LENGTH - registrant.length());
        String checkDigit = String.valueOf(this.modTenFormula.generateCheckDigit("9790" + registrant + item));
        String separator = this.resolveSeparator();
        return new Ismn(registrant, item, checkDigit, separator);
    }

    private String resolveRegistrant() {
        return Optional.ofNullable(this.dummy4j.oneOf(this.registrants)).orElseGet(this::generateRegistrant);
    }

    private String generateRegistrant() {
        IsmnRegistrantRange range = this.dummy4j.oneOf(REGISTRANT_RANGES);
        Integer registrant = this.dummy4j.number().nextInt(range.getMin(), range.getMax());
        return Padding.leftPad(String.valueOf(registrant), 3, '0');
    }

    private String resolveSeparator() {
        return Optional.ofNullable(this.dummy4j.oneOf(this.separators)).orElseGet(() -> this.dummy4j.expressionResolver().resolve(ISMN_SEPARATOR_KEY));
    }
}

