/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber;

import dev.codesoapbox.dummy4j.dummies.shared.math.NumberValidator;
import dev.codesoapbox.dummy4j.exceptions.InvalidIsbnParameterException;
import dev.codesoapbox.dummy4j.exceptions.ValueOutOfRangeException;
import java.util.Objects;

final class IsbnRegistrationGroupRange {
    private static final int MAX_REGISTRATION_GROUP = 99999;
    private static final int MIN_REGISTRATION_GROUP = 0;
    private int min;
    private int max;

    private IsbnRegistrationGroupRange() {
    }

    static IsbnRegistrationGroupRange from(int min, int max) {
        IsbnRegistrationGroupRange.validateRange(min, max);
        IsbnRegistrationGroupRange range = new IsbnRegistrationGroupRange();
        range.min = min;
        range.max = max;
        return range;
    }

    private static void validateRange(int min, int max) {
        try {
            NumberValidator.inRange(max, 0.0f, 99999.0f);
            NumberValidator.inRange(min, 0.0f, max);
        }
        catch (ValueOutOfRangeException e) {
            String message = String.format("Invalid registration group range from %d to %d", min, max);
            throw new InvalidIsbnParameterException(message, e);
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsbnRegistrationGroupRange group = (IsbnRegistrationGroupRange)o;
        return this.min == group.min && this.max == group.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return "IsbnRegistrationGroupRange{min=" + this.min + ", max=" + this.max + '}';
    }
}

