/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.InternationalNumberCheckDigitFormulaProvider;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.Isbn;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.IsbnRegistrationGroupRange;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.IsbnType;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.IsbnValidator;
import dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas.CheckDigit10AsXFormatter;
import dev.codesoapbox.dummy4j.exceptions.InvalidDefinitionException;
import dev.codesoapbox.dummy4j.exceptions.InvalidIsbnParameterException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class IsbnBuilder {
    static final Integer ISBN_BASE_LENGTH = 9;
    static final String ISBN_PREFIX_KEY = "#{identifier.isbn.prefix}";
    static final String ISBN_SEPARATOR_KEY = "#{identifier.isbn.separator}";
    static final List<IsbnRegistrationGroupRange> REGISTRATION_GROUP_RANGES = Arrays.asList(IsbnRegistrationGroupRange.from(0, 5), IsbnRegistrationGroupRange.from(600, 625), IsbnRegistrationGroupRange.from(65, 65), IsbnRegistrationGroupRange.from(7, 7), IsbnRegistrationGroupRange.from(80, 94), IsbnRegistrationGroupRange.from(950, 989), IsbnRegistrationGroupRange.from(9917, 9989), IsbnRegistrationGroupRange.from(99901, 99983));
    private final Dummy4j dummy4j;
    private final IsbnValidator validator;
    private final InternationalNumberCheckDigitFormulaProvider checkDigitFormulaProvider;
    private List<IsbnType> types;
    private List<String> prefixes;
    private List<String> registrationGroups;
    private List<String> registrants;
    private List<String> publications;
    private List<String> separators;

    public IsbnBuilder(Dummy4j dummy4j, IsbnValidator validator, InternationalNumberCheckDigitFormulaProvider checkDigitFormulaProvider) {
        this.dummy4j = dummy4j;
        this.validator = validator;
        this.checkDigitFormulaProvider = checkDigitFormulaProvider;
    }

    public IsbnBuilder withRandomType() {
        this.types = Collections.emptyList();
        return this;
    }

    public IsbnBuilder withRandomType(IsbnType ... types) {
        this.types = Arrays.asList(types);
        return this;
    }

    public IsbnBuilder withType(IsbnType type) {
        this.types = Collections.singletonList(type);
        return this;
    }

    public IsbnBuilder withRandomPrefix() {
        this.prefixes = Collections.emptyList();
        return this;
    }

    public IsbnBuilder withRandomPrefix(String ... prefixes) {
        Arrays.stream(prefixes).forEach(this.validator::testForInvalidPrefix);
        this.prefixes = Arrays.asList(prefixes);
        return this;
    }

    public IsbnBuilder withPrefix(String prefix) {
        this.validator.testForInvalidPrefix(prefix);
        this.prefixes = Collections.singletonList(prefix);
        return this;
    }

    public IsbnBuilder withRandomRegistrationGroup() {
        this.registrationGroups = Collections.emptyList();
        return this;
    }

    public IsbnBuilder withRandomRegistrationGroup(String ... registrationGroups) {
        Arrays.stream(registrationGroups).forEach(this.validator::testForInvalidRegistrationGroup);
        this.registrationGroups = Arrays.asList(registrationGroups);
        return this;
    }

    public IsbnBuilder withRegistrationGroup(String group) {
        this.validator.testForInvalidRegistrationGroup(group);
        this.registrationGroups = Collections.singletonList(group);
        return this;
    }

    public IsbnBuilder withRandomRegistrant() {
        this.registrants = Collections.emptyList();
        return this;
    }

    public IsbnBuilder withRandomRegistrant(String ... registrants) {
        Arrays.stream(registrants).forEach(this.validator::testForInvalidOtherPart);
        this.registrants = Arrays.asList(registrants);
        return this;
    }

    public IsbnBuilder withRegistrant(String registrant) {
        this.validator.testForInvalidOtherPart(registrant);
        this.registrants = Collections.singletonList(registrant);
        return this;
    }

    public IsbnBuilder withRandomPublication() {
        this.publications = Collections.emptyList();
        return this;
    }

    public IsbnBuilder withRandomPublication(String ... publications) {
        Arrays.stream(publications).forEach(this.validator::testForInvalidOtherPart);
        this.publications = Arrays.asList(publications);
        return this;
    }

    public IsbnBuilder withPublication(String publication) {
        this.validator.testForInvalidOtherPart(publication);
        this.publications = Collections.singletonList(publication);
        return this;
    }

    public IsbnBuilder withRandomSeparator() {
        this.separators = Collections.emptyList();
        return this;
    }

    public IsbnBuilder withRandomSeparator(String ... separators) {
        this.separators = Arrays.asList(separators);
        return this;
    }

    public IsbnBuilder withSeparator(String separator) {
        this.separators = Collections.singletonList(separator);
        return this;
    }

    public IsbnBuilder withoutSeparator() {
        this.separators = Collections.singletonList("");
        return this;
    }

    public Isbn build() {
        IsbnType type = this.resolveType();
        String prefix = this.resolvePrefix(type);
        String group = this.resolveRegistrationGroup();
        String publication = this.dummy4j.oneOf(this.publications);
        String registrant = this.resolveRegistrant(group.length(), publication);
        if (publication == null) {
            publication = this.dummy4j.number().digits(ISBN_BASE_LENGTH - (group.length() + registrant.length()));
        }
        String separator = this.resolveSeparator();
        String checkDigit = this.generateCheckDigit(type, prefix + group + registrant + publication);
        return new Isbn(type, prefix, group, registrant, publication, separator, checkDigit);
    }

    private IsbnType resolveType() {
        return Optional.ofNullable(this.dummy4j.oneOf(this.types)).orElse(this.dummy4j.nextEnum(IsbnType.class));
    }

    private String resolvePrefix(IsbnType type) {
        if (!type.requiresPrefix()) {
            return "";
        }
        return Optional.ofNullable(this.dummy4j.oneOf(this.prefixes)).orElseGet(this::resolvePrefixDefinition);
    }

    private String resolvePrefixDefinition() {
        String prefix = this.dummy4j.expressionResolver().resolve(ISBN_PREFIX_KEY);
        try {
            this.validator.testForInvalidPrefix(prefix);
        }
        catch (InvalidIsbnParameterException e) {
            throw new InvalidDefinitionException(ISBN_PREFIX_KEY, e, prefix);
        }
        return prefix;
    }

    private String resolveRegistrationGroup() {
        return Optional.ofNullable(this.dummy4j.oneOf(this.registrationGroups)).orElseGet(this::generateRegistrationGroup);
    }

    private String generateRegistrationGroup() {
        IsbnRegistrationGroupRange range = this.dummy4j.oneOf(REGISTRATION_GROUP_RANGES);
        int group = this.dummy4j.number().nextInt(range.getMin(), range.getMax());
        return String.valueOf(group);
    }

    private String resolveRegistrant(int registrationGroupLength, String publication) {
        return Optional.ofNullable(this.dummy4j.oneOf(this.registrants)).orElseGet(() -> this.generateRegistrant(registrationGroupLength, publication));
    }

    private String generateRegistrant(Integer registrationGroupLength, String publication) {
        if (publication != null) {
            return this.generateRegistrantBasedOnPublication(registrationGroupLength, publication);
        }
        return this.generateRegistrantBasedOnRemainingSpace(registrationGroupLength);
    }

    private String generateRegistrantBasedOnPublication(Integer registrationGroupLength, String publication) {
        int howMany = ISBN_BASE_LENGTH - (registrationGroupLength + publication.length());
        if (howMany <= 0) {
            return "";
        }
        return this.dummy4j.number().digits(howMany);
    }

    private String generateRegistrantBasedOnRemainingSpace(Integer registrationGroupLength) {
        int max = ISBN_BASE_LENGTH - (registrationGroupLength + 1);
        if (max <= 0) {
            return "";
        }
        int howMany = ISBN_BASE_LENGTH - (registrationGroupLength + this.dummy4j.number().nextInt(1, max));
        return this.dummy4j.number().digits(howMany);
    }

    private String resolveSeparator() {
        return Optional.ofNullable(this.dummy4j.oneOf(this.separators)).orElseGet(() -> this.dummy4j.expressionResolver().resolve(ISBN_SEPARATOR_KEY));
    }

    private String generateCheckDigit(IsbnType type, String input) {
        if (type == IsbnType.ISBN_10) {
            Integer digit = this.checkDigitFormulaProvider.getModElevenFormula().generateCheckDigit(input);
            return CheckDigit10AsXFormatter.formatCheckDigit(digit);
        }
        return String.valueOf(this.checkDigitFormulaProvider.getModTenFormula().generateCheckDigit(input));
    }

    public String toString() {
        return "IsbnBuilder{isbnType=" + this.types + ", prefixes=" + this.prefixes + ", registrationGroups=" + this.registrationGroups + ", registrants=" + this.registrants + ", publications=" + this.publications + ", separators=" + this.separators + '}';
    }
}

