/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber;

import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.IsbnType;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringValidator;
import java.util.Objects;
import java.util.StringJoiner;

public final class Isbn {
    private final IsbnType type;
    private final String prefix;
    private final String registrationGroup;
    private final String registrant;
    private final String publication;
    private final String checkDigit;
    private final String separator;

    Isbn(IsbnType type, String prefix, String registrationGroup, String registrant, String publication, String separator, String checkDigit) {
        this.type = type;
        this.prefix = prefix;
        this.registrationGroup = registrationGroup;
        this.registrant = registrant;
        this.publication = publication;
        this.checkDigit = checkDigit;
        this.separator = separator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRegistrationGroup() {
        return this.registrationGroup;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public String getPublication() {
        return this.publication;
    }

    public String getCheckDigit() {
        return this.checkDigit;
    }

    public IsbnType getType() {
        return this.type;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Isbn isbn = (Isbn)o;
        return this.type == isbn.type && this.prefix.equals(isbn.prefix) && this.registrationGroup.equals(isbn.registrationGroup) && this.registrant.equals(isbn.registrant) && this.publication.equals(isbn.publication) && this.checkDigit.equals(isbn.checkDigit) && this.separator.equals(isbn.separator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.prefix, this.registrationGroup, this.registrant, this.publication, this.checkDigit, this.separator});
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(this.separator == null ? "" : this.separator);
        if (!StringValidator.isNullOrEmpty(this.prefix)) {
            joiner.add(this.prefix);
        }
        return joiner.add(this.registrationGroup).add(this.registrant).add(this.publication).add(this.checkDigit).toString();
    }
}

