/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber.Gs1PrefixRange;
import dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas.ModTenFormula;
import dev.codesoapbox.dummy4j.dummies.shared.string.Padding;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

abstract class GtinWithGs1PrefixBuilder<T extends GtinWithGs1PrefixBuilder<T>> {
    final Dummy4j dummy4j;
    final ModTenFormula modTenFormula;
    private List<Gs1PrefixRange> ranges;

    protected GtinWithGs1PrefixBuilder(Dummy4j dummy4j, ModTenFormula modTenFormula) {
        this.dummy4j = dummy4j;
        this.modTenFormula = modTenFormula;
    }

    protected abstract T self();

    public T withRandomGs1PrefixRange() {
        this.ranges = Collections.emptyList();
        return this.self();
    }

    public T withRandomGs1PrefixRange(Gs1PrefixRange ... ranges) {
        this.ranges = Arrays.asList(ranges);
        return this.self();
    }

    public T withGs1PrefixRange(Gs1PrefixRange range) {
        this.ranges = Collections.singletonList(range);
        return this.self();
    }

    public abstract String build();

    String createBasicGtin(int dataPartLength) {
        String prefix = this.getGs1Prefix();
        String dataPart = this.dummy4j.number().digits(dataPartLength);
        String checkDigit = this.getCheckDigit(prefix + dataPart);
        return prefix + dataPart + checkDigit;
    }

    String getGs1Prefix() {
        Gs1PrefixRange range = Optional.ofNullable(this.dummy4j.oneOf(this.ranges)).orElseGet(() -> this.dummy4j.nextEnum(Gs1PrefixRange.class));
        if (range.isSingleValue()) {
            return Padding.leftPad(String.valueOf(range.getMin()), 3, '0');
        }
        Integer prefix = this.dummy4j.number().nextInt(range.getMin(), range.getMax());
        return Padding.leftPad(String.valueOf(prefix), 3, '0');
    }

    String getCheckDigit(String input) {
        return String.valueOf(this.modTenFormula.generateCheckDigit(input));
    }
}

