/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.DateAndTimeDummy;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber.Gtin14Builder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber.SsccFactory;
import dev.codesoapbox.dummy4j.dummies.shared.string.Padding;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Gs1Dash128Factory {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    private static final String FNC_1 = "<FNC1>";
    final List<Supplier<String>> suppliers;
    private final Dummy4j dummy4j;

    public Gs1Dash128Factory(Dummy4j dummy4j, Gtin14Builder gtin14Builder, SsccFactory ssccFactory) {
        this.dummy4j = dummy4j;
        this.suppliers = this.getSuppliers(dummy4j, gtin14Builder, ssccFactory);
    }

    private List<Supplier<String>> getSuppliers(Dummy4j dummy4j, Gtin14Builder gtin14Builder, SsccFactory ssccFactory) {
        Supplier[] supplierArray = new Supplier[10];
        supplierArray[0] = () -> gtin14Builder.withApplicationIdentifier().build();
        supplierArray[1] = ssccFactory::createCode;
        supplierArray[2] = () -> {
            String past = this.formattedDate(d -> d.past(12L, ChronoUnit.MONTHS));
            return "(11)" + past;
        };
        supplierArray[3] = () -> {
            String past = this.formattedDate(d -> d.past(10L, ChronoUnit.MONTHS));
            return "(13)" + past;
        };
        supplierArray[4] = () -> {
            String future = this.formattedDate(d -> d.future(36L, ChronoUnit.MONTHS));
            return "(12)" + future;
        };
        supplierArray[5] = () -> {
            String future = this.formattedDate(d -> d.future(24L, ChronoUnit.MONTHS));
            return "(15)" + future;
        };
        supplierArray[6] = () -> {
            String future = this.formattedDate(d -> d.future(12L, ChronoUnit.MONTHS));
            return "(17)" + future;
        };
        supplierArray[7] = () -> {
            String value = String.valueOf(dummy4j.number().nextInt(1, 99));
            return "(20)" + Padding.leftPad(value, 2, '0');
        };
        supplierArray[8] = () -> {
            int value = dummy4j.number().nextInt(1, 99999999);
            return "(30)" + value + FNC_1;
        };
        supplierArray[9] = () -> {
            int value = dummy4j.number().nextInt(1, 999999);
            return "(8005)" + value + FNC_1;
        };
        return Arrays.asList(supplierArray);
    }

    private String formattedDate(Function<DateAndTimeDummy, LocalDateTime> dateFunc) {
        return this.formatDate(dateFunc.apply(this.dummy4j.dateAndTime()).toLocalDate());
    }

    private String formatDate(LocalDate date) {
        return DATE_FORMATTER.format(date);
    }

    public String createCode() {
        int howManyParts = this.dummy4j.number().nextInt(2, 3);
        List selected = this.dummy4j.unique().of(() -> this.dummy4j.oneOf(this.suppliers), supplier -> this.dummy4j.listOf(howManyParts, supplier));
        return selected.stream().map(Supplier::get).collect(Collectors.joining());
    }
}

