/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.shared.checkdigitformulas.LuhnFormula;

class DeviceIdentifierFactory {
    static final String REPORTING_BODY_ID_KEY = "#{identifier.device.tac.reporting_body}";
    static final int TAC_ID_LENGTH = 6;
    static final int SERIAL_NUMBER_LENGTH = 6;
    static final int SOFTWARE_VERSION_LENGTH = 2;
    private static final String SEPARATOR = "-";
    private final Dummy4j dummy4j;

    DeviceIdentifierFactory(Dummy4j dummy4j) {
        this.dummy4j = dummy4j;
    }

    String createTac() {
        String reportingBodyId = this.dummy4j.expressionResolver().resolve(REPORTING_BODY_ID_KEY);
        return reportingBodyId + SEPARATOR + this.dummy4j.number().digits(6);
    }

    String createImei(LuhnFormula luhnFormula) {
        String firstPart = this.createTac() + SEPARATOR + this.getSerialNumber();
        return firstPart + SEPARATOR + luhnFormula.generateCheckDigit(firstPart);
    }

    private String getSerialNumber() {
        return this.dummy4j.number().digits(6);
    }

    String createImeisv() {
        return this.createTac() + SEPARATOR + this.getSerialNumber() + SEPARATOR + this.dummy4j.number().digits(2);
    }
}

