/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.identifier;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.InternationalStandardNumberFactory;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber.Gtin13Builder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber.Gtin14Builder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.articlenumber.Gtin8Builder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.Isbn;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.booknumber.IsbnBuilder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber.Ismn;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.musicnumber.IsmnBuilder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.namenumber.IsniBuilder;
import dev.codesoapbox.dummy4j.dummies.identifier.internationalnumber.namenumber.OrcidBuilder;
import dev.codesoapbox.dummy4j.dummies.shared.string.StringSanitizer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;

public class IdentifierDummy {
    private final Dummy4j dummy4j;
    private final InternationalStandardNumberFactory internationalStandardNumberFactory;

    public IdentifierDummy(Dummy4j dummy4j, InternationalStandardNumberFactory internationalStandardNumberFactory) {
        this.dummy4j = dummy4j;
        this.internationalStandardNumberFactory = internationalStandardNumberFactory;
    }

    public UUID uuid() {
        return UUID.nameUUIDFromBytes(String.valueOf(this.dummy4j.number().nextLong()).getBytes(StandardCharsets.UTF_8));
    }

    public String issn() {
        return this.internationalStandardNumberFactory.createIssn();
    }

    public Isbn isbn() {
        return this.internationalStandardNumberFactory.createIsbnBuilder().build();
    }

    public IsbnBuilder isbnBuilder() {
        return this.internationalStandardNumberFactory.createIsbnBuilder();
    }

    public Ismn ismn() {
        return this.internationalStandardNumberFactory.createIsmnBuilder().build();
    }

    public IsmnBuilder ismnBuilder() {
        return this.internationalStandardNumberFactory.createIsmnBuilder();
    }

    public String isni() {
        return this.internationalStandardNumberFactory.createIsniBuilder().build();
    }

    public IsniBuilder isniBuilder() {
        return this.internationalStandardNumberFactory.createIsniBuilder();
    }

    public String orcid() {
        return this.internationalStandardNumberFactory.createOrcidBuilder().build();
    }

    public OrcidBuilder orcidBuilder() {
        return this.internationalStandardNumberFactory.createOrcidBuilder();
    }

    public String ean8() {
        return this.gtin8();
    }

    public String gtin8() {
        return this.internationalStandardNumberFactory.createGtin8Builder().build();
    }

    public Gtin8Builder ean8Builder() {
        return this.gtin8Builder();
    }

    public Gtin8Builder gtin8Builder() {
        return this.internationalStandardNumberFactory.createGtin8Builder();
    }

    public String ean13() {
        return this.gtin13();
    }

    public String gtin13() {
        return this.internationalStandardNumberFactory.createGtin13Builder().build();
    }

    public Gtin13Builder ean13Builder() {
        return this.gtin13Builder();
    }

    public Gtin13Builder gtin13Builder() {
        return this.internationalStandardNumberFactory.createGtin13Builder();
    }

    public String ean14() {
        return this.gtin14();
    }

    public String gtin14() {
        return this.internationalStandardNumberFactory.createGtin14Builder().build();
    }

    public Gtin14Builder ean14Builder() {
        return this.gtin14Builder();
    }

    public Gtin14Builder gtin14Builder() {
        return this.internationalStandardNumberFactory.createGtin14Builder();
    }

    public String gtin12() {
        return this.internationalStandardNumberFactory.createUpc();
    }

    public String upc() {
        return this.internationalStandardNumberFactory.createUpc();
    }

    public String gs1Dash128() {
        return this.internationalStandardNumberFactory.createGs1Dash128();
    }

    public String sscc() {
        return this.internationalStandardNumberFactory.createSscc();
    }

    public String asin() {
        return "B00" + this.getAsinAlphaNumericPart();
    }

    private String getAsinAlphaNumericPart() {
        int numbers = this.dummy4j.number().nextInt(10, 99999);
        int letters = 7 - String.valueOf(numbers).length();
        String letterPart = this.dummy4j.lorem().characters(letters).toUpperCase(Locale.ENGLISH);
        return StringSanitizer.sanitizeForEmail(letterPart) + numbers;
    }

    public String tac() {
        return this.internationalStandardNumberFactory.createTac();
    }

    public String imei() {
        return this.internationalStandardNumberFactory.createImei();
    }

    public String imeisv() {
        return this.internationalStandardNumberFactory.createImeisv();
    }
}

