/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.shared.math.NumberFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PriceBuilder {
    static final float LOWER_BOUNDARY = 1.0f;
    static final float UPPER_BOUNDARY = 100.0f;
    static final float LOWER_BOUNDARY_FOR_HIGH_PRICE = 100.0f;
    static final float UPPER_BOUNDARY_FOR_HIGH_PRICE = 10000.0f;
    private final Dummy4j dummy4j;
    private boolean currencyFromDefinitions;
    private List<String> currencies = Collections.emptyList();
    private float min = 1.0f;
    private float max = 100.0f;

    public PriceBuilder(Dummy4j dummy4j) {
        this.dummy4j = dummy4j;
    }

    public PriceBuilder withCurrency(String customCurrency) {
        this.currencies = Collections.singletonList(customCurrency);
        this.currencyFromDefinitions = false;
        return this;
    }

    public PriceBuilder withRandomCurrency() {
        this.currencyFromDefinitions = true;
        this.currencies = Collections.emptyList();
        return this;
    }

    public PriceBuilder withRandomCurrency(String ... currencies) {
        this.currencies = Arrays.asList(currencies);
        this.currencyFromDefinitions = false;
        return this;
    }

    public PriceBuilder withoutCurrency() {
        this.currencies = Collections.emptyList();
        this.currencyFromDefinitions = false;
        return this;
    }

    public PriceBuilder high() {
        this.min = 100.0f;
        this.max = 10000.0f;
        return this;
    }

    public PriceBuilder withinRange(float min, float max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public String build() {
        String currency = this.getCurrency();
        if (currency.isEmpty()) {
            return this.getAmount();
        }
        return currency + " " + this.getAmount();
    }

    private String getCurrency() {
        if (this.currencyFromDefinitions) {
            return this.dummy4j.expressionResolver().resolve("#{finance.currency.code}");
        }
        return Optional.ofNullable(this.dummy4j.oneOf(this.currencies)).orElse("");
    }

    private String getAmount() {
        return NumberFormatter.toTwoDecimals(this.dummy4j.number().nextFloat(this.min, this.max));
    }
}

