/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies.finance;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.dummies.address.Address;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCard;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardNumberBuilder;
import dev.codesoapbox.dummy4j.dummies.finance.CreditCardProvider;
import dev.codesoapbox.dummy4j.dummies.shared.string.Padding;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CreditCardBuilder {
    static final int MAX_DAYS_FOR_EXPIRY_DATE = 3650;
    static final int MIN_SECURITY_CODE = 100;
    static final int MAX_SECURITY_CODE = 999;
    private final Dummy4j dummy4j;
    private final CreditCardNumberBuilder numberBuilder;
    private List<CreditCardProvider> providers = Collections.emptyList();

    public CreditCardBuilder(Dummy4j dummy4j, CreditCardNumberBuilder numberBuilder) {
        this.dummy4j = dummy4j;
        this.numberBuilder = numberBuilder;
    }

    public CreditCardBuilder withRandomProvider() {
        this.providers = Collections.emptyList();
        return this;
    }

    public CreditCardBuilder withRandomProvider(CreditCardProvider ... providers) {
        this.providers = Arrays.asList(providers);
        return this;
    }

    public CreditCardBuilder withProvider(CreditCardProvider provider) {
        this.providers = Collections.singletonList(provider);
        return this;
    }

    public CreditCardBuilder withoutNumberFormatting() {
        this.numberBuilder.withoutFormatting();
        return this;
    }

    public CreditCard build() {
        CreditCardProvider provider = Optional.ofNullable(this.dummy4j.oneOf(this.providers)).orElseGet(() -> this.dummy4j.nextEnum(CreditCardProvider.class));
        String number = this.numberBuilder.withProvider(provider).build();
        String ownerName = this.dummy4j.name().firstName() + " " + this.dummy4j.name().lastName();
        Address ownerAddress = this.dummy4j.address().full();
        String expiryDate = this.generateExpiryDate();
        String securityCode = String.valueOf(this.dummy4j.number().nextInt(100, 999));
        return new CreditCard(number, provider, ownerName, ownerAddress, expiryDate, securityCode);
    }

    private String generateExpiryDate() {
        LocalDate date = this.dummy4j.dateAndTime().future(3650L, ChronoUnit.DAYS).toLocalDate();
        int month = date.getMonthValue();
        int year = date.getYear();
        return Padding.leftPad(String.valueOf(month), 2, '0') + "/" + year;
    }

    public String toString() {
        return "CreditCardBuilder{numberBuilder=" + this.numberBuilder + ", providers=" + this.providers + '}';
    }
}

