/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.convenience;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class MethodPathLoader {
    private static final String JAVA_LIB_PREFIX = "java.";
    private static final String SEPARATOR = ".";

    MethodPathLoader() {
    }

    public String getSeparator() {
        return SEPARATOR;
    }

    public List<String> load(Class<?> rootClass) {
        HashMap<String, Object> methodMap = new HashMap<String, Object>();
        methodMap.put(rootClass.getSimpleName(), MethodPathLoader.getMethodsForClass(rootClass, new ArrayList()));
        return MethodPathLoader.mapToStrings(methodMap, "");
    }

    private static Map<String, Object> getMethodsForClass(Class<?> sourceClass, List<Class<?>> previousClasses) {
        previousClasses.add(sourceClass);
        HashMap<String, Object> methodMap = new HashMap<String, Object>();
        for (Method method : sourceClass.getDeclaredMethods()) {
            if (!MethodPathLoader.isPublic(method) || !MethodPathLoader.isNotRecursion(method, previousClasses)) continue;
            methodMap.put(method.getName() + "()", MethodPathLoader.getSubMethods(method, previousClasses));
        }
        return methodMap;
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static boolean isNotRecursion(Method method, List<Class<?>> previousClasses) {
        return !previousClasses.contains(method.getReturnType());
    }

    private static Map<String, Object> getSubMethods(Method method, List<Class<?>> previousClasses) {
        if (MethodPathLoader.isNotNativeJavaClass(method)) {
            return MethodPathLoader.getMethodsForClass(method.getReturnType(), previousClasses);
        }
        return Collections.emptyMap();
    }

    private static boolean isNotNativeJavaClass(Method method) {
        return method.getReturnType().getPackage() != null && !method.getReturnType().getPackage().getName().startsWith(JAVA_LIB_PREFIX);
    }

    private static List<String> mapToStrings(Map<String, Object> methodMap, String prefix) {
        return methodMap.entrySet().stream().map(e -> MethodPathLoader.mapEntryToStrings(e, prefix)).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    private static List<String> mapEntryToStrings(Map.Entry<String, Object> mapEntry, String prefix) {
        Map value = (Map)mapEntry.getValue();
        return MethodPathLoader.mapMapToStrings(value, prefix, mapEntry.getKey());
    }

    private static List<String> mapMapToStrings(Map<String, Object> map, String prefix, String key) {
        if (map.isEmpty()) {
            return Collections.singletonList(prefix + key);
        }
        List<String> strings = MethodPathLoader.mapToStrings(map, prefix + key + SEPARATOR);
        if (MethodPathLoader.isNotRoot(prefix)) {
            strings.add(prefix + key);
        }
        return strings;
    }

    private static boolean isNotRoot(String prefix) {
        return !prefix.isEmpty();
    }
}

