/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.convenience;

import dev.codesoapbox.dummy4j.Dummy4j;
import dev.codesoapbox.dummy4j.RandomService;
import dev.codesoapbox.dummy4j.convenience.MethodFinder;
import dev.codesoapbox.dummy4j.convenience.MethodPathLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class ConvenienceMethods {
    private final RandomService random;
    private final MethodFinder methodFinder;

    public ConvenienceMethods(RandomService random) {
        this.random = random;
        this.methodFinder = new MethodFinder(Dummy4j.class, new MethodPathLoader());
    }

    ConvenienceMethods(RandomService random, MethodFinder methodFinder) {
        this.random = random;
        this.methodFinder = methodFinder;
    }

    public <T> List<T> listOf(int count, Supplier<T> supplier) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            list.add(supplier.get());
        }
        return list;
    }

    public <T> Set<T> setOf(int count, Supplier<T> supplier) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < count; ++i) {
            set.add(supplier.get());
        }
        return set;
    }

    @SafeVarargs
    public final <T> T oneOf(T ... array) {
        if (array.length == 0) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        return array[this.random.nextInt(array.length - 1)];
    }

    public <T> T oneOf(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(this.random.nextInt(list.size() - 1));
    }

    public <T> T oneOf(Set<T> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        if (set.size() == 1) {
            return (T)set.toArray()[0];
        }
        return (T)set.toArray()[this.random.nextInt(set.size() - 1)];
    }

    @SafeVarargs
    public final <T> T oneOf(Supplier<T> ... suppliers) {
        if (suppliers == null || suppliers.length == 0) {
            return null;
        }
        if (suppliers.length == 1) {
            return suppliers[0].get();
        }
        return suppliers[this.random.nextInt(suppliers.length - 1)].get();
    }

    public <T> T chance(int howMany, int in, Supplier<T> supplier) {
        if (this.random.nextInt(1, in) > howMany) {
            return null;
        }
        return supplier.get();
    }

    public boolean chance(int howMany, int in) {
        return this.random.nextInt(1, in) <= howMany;
    }

    public <T extends Enum<?>> T nextEnum(Class<T> clazz) {
        int x = this.random.nextInt(((Enum[])clazz.getEnumConstants()).length - 1);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public String find(String value) {
        return this.methodFinder.find(value);
    }
}

