/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j;

import dev.codesoapbox.dummy4j.ExpressionResolver;
import dev.codesoapbox.dummy4j.RandomService;
import dev.codesoapbox.dummy4j.ResolvedValue;
import dev.codesoapbox.dummy4j.definitions.LocalizedDummyDefinitions;
import dev.codesoapbox.dummy4j.definitions.providers.DefinitionProvider;
import dev.codesoapbox.dummy4j.exceptions.MissingLocaleDefinitionsException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DefaultExpressionResolver
implements ExpressionResolver {
    private static final String ESCAPE_PREFIX = "\\\\?";
    private static final Pattern MULTI_LOCALE_VARIABLE_PATTERN = Pattern.compile("#\\{{2}((?:(?!#\\{|}).)*)}{2}");
    private static final Pattern SINGLE_LOCALE_VARIABLE_PATTERN = Pattern.compile("#\\{(?!\\{)((?:(?!#\\{|}).)*)}");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\\\?#(?!\\{)");
    private static final Logger LOG = Logger.getLogger(DefaultExpressionResolver.class.getName());
    final RandomService randomService;
    final List<String> locales;
    final Map<String, LocalizedDummyDefinitions> localizedDefinitions;

    public DefaultExpressionResolver(List<String> locales, RandomService randomService, DefinitionProvider definitionProvider) {
        if (locales == null || locales.isEmpty()) {
            locales = Collections.singletonList("en");
        }
        this.locales = locales;
        this.randomService = randomService;
        this.localizedDefinitions = definitionProvider.get().stream().collect(Collectors.toMap(LocalizedDummyDefinitions::getLocale, d -> d));
        locales.forEach(locale -> {
            if (!this.localizedDefinitions.containsKey(locale)) {
                throw new MissingLocaleDefinitionsException((String)locale);
            }
        });
    }

    @Override
    public String resolve(String expression) {
        ResolvedValue resolvedValue = ResolvedValue.of("", expression);
        do {
            resolvedValue = this.replaceMultiLocalePlaceholders(resolvedValue);
        } while (MULTI_LOCALE_VARIABLE_PATTERN.matcher((resolvedValue = this.replaceSingleLocalePlaceholders(resolvedValue)).getValue()).find() || SINGLE_LOCALE_VARIABLE_PATTERN.matcher(resolvedValue.getValue()).find());
        return this.replaceDigitPlaceholders(resolvedValue).getValue();
    }

    private ResolvedValue replaceMultiLocalePlaceholders(ResolvedValue resolvedValue) {
        String expression = resolvedValue.getValue();
        Matcher expressionMatcher = MULTI_LOCALE_VARIABLE_PATTERN.matcher(expression);
        return this.replace(resolvedValue, expressionMatcher, locale -> this.resolvePathWithinAllLocales(expressionMatcher.group(1)));
    }

    private ResolvedValue replace(ResolvedValue resolvedValue, Matcher expressionMatcher, Function<String, ResolvedValue> replacementSupplier) {
        String expression = resolvedValue.getValue();
        String locale = resolvedValue.getLocale();
        StringBuffer b = new StringBuffer(expression.length());
        while (expressionMatcher.find()) {
            if (expressionMatcher.group().charAt(0) == '\\') {
                expressionMatcher.appendReplacement(b, expressionMatcher.group().substring(1));
                continue;
            }
            ResolvedValue newValue = replacementSupplier.apply(locale);
            locale = newValue.getLocale();
            expressionMatcher.appendReplacement(b, Matcher.quoteReplacement(newValue.getValue()));
        }
        expressionMatcher.appendTail(b);
        return ResolvedValue.of(locale, b.toString());
    }

    private ResolvedValue resolvePathWithinAllLocales(String path) {
        List<ResolvedValue> result = this.locales.stream().flatMap(locale -> this.localizedDefinitions.get(locale).resolve(path).stream().map(v -> ResolvedValue.of(locale, v))).collect(Collectors.toList());
        if (!result.isEmpty()) {
            return this.getRandom(result);
        }
        LOG.log(Level.FINE, "Could not resolve path: {0} in any locale", path);
        return ResolvedValue.of("", "");
    }

    private ResolvedValue getRandom(List<ResolvedValue> result) {
        int i = this.randomService.nextInt(result.size() - 1);
        return result.get(i);
    }

    private ResolvedValue replaceSingleLocalePlaceholders(ResolvedValue resolvedValue) {
        String expression = resolvedValue.getValue();
        Matcher expressionMatcher = SINGLE_LOCALE_VARIABLE_PATTERN.matcher(expression);
        return this.replace(resolvedValue, expressionMatcher, locale -> this.resolvePathWithinSingleLocale(expressionMatcher.group(1), (String)locale));
    }

    private ResolvedValue resolvePathWithinSingleLocale(String path, String originalLocale) {
        for (String locale : this.locales) {
            List<String> result;
            if (!originalLocale.isEmpty() && !originalLocale.equals(locale) || (result = this.localizedDefinitions.get(locale).resolve(path)) == null || result.isEmpty()) continue;
            return ResolvedValue.of(locale, this.getRandomString(result));
        }
        if (!"".equals(originalLocale)) {
            LOG.log(Level.FINE, "Could not resolve path: {0} for locale: {1}", new Object[]{path, originalLocale});
        } else {
            LOG.log(Level.FINE, "Could not resolve path: {0} in any locale", path);
        }
        return ResolvedValue.of("", "");
    }

    private String getRandomString(List<String> result) {
        int i = this.randomService.nextInt(result.size() - 1);
        return result.get(i);
    }

    private ResolvedValue replaceDigitPlaceholders(ResolvedValue resolvedValue) {
        String expressionWithResolvedKeys = resolvedValue.getValue();
        Matcher digitMatcher = DIGIT_PATTERN.matcher(expressionWithResolvedKeys);
        return this.replace(resolvedValue, digitMatcher, locale -> ResolvedValue.of(locale, String.valueOf(this.randomService.nextInt(9))));
    }
}

