/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions.providers.files.yaml;

import dev.codesoapbox.dummy4j.definitions.LocalizedDummyDefinitions;
import dev.codesoapbox.dummy4j.definitions.LocalizedDummyDefinitionsMap;
import dev.codesoapbox.dummy4j.definitions.providers.DefinitionProvider;
import dev.codesoapbox.dummy4j.definitions.providers.MapMerger;
import dev.codesoapbox.dummy4j.definitions.providers.files.yaml.YamlFileLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class YamlFileDefinitionProvider
implements DefinitionProvider {
    private static final String DEFAULT_PATH = "dummy4j";
    private final YamlFileLoader yamlFileLoader;
    private final MapMerger mapMerger;
    private final List<String> paths;
    private List<LocalizedDummyDefinitions> definitions;

    public YamlFileDefinitionProvider(YamlFileLoader yamlFileLoader, MapMerger mapMerger, List<String> paths) {
        this.mapMerger = mapMerger;
        this.yamlFileLoader = yamlFileLoader;
        this.paths = paths;
    }

    public static YamlFileDefinitionProvider standard() {
        return YamlFileDefinitionProvider.withPaths(Collections.singletonList(DEFAULT_PATH));
    }

    public static YamlFileDefinitionProvider withPaths(List<String> paths) {
        return new YamlFileDefinitionProvider(YamlFileLoader.standard(), new MapMerger(), paths);
    }

    @Override
    public List<LocalizedDummyDefinitions> get() {
        if (this.definitions != null) {
            return this.definitions;
        }
        this.loadDefinitions();
        return this.definitions;
    }

    private void loadDefinitions() {
        List<Map<String, Object>> unmergedDefinitionMaps = this.yamlFileLoader.loadYamlFiles(this.paths);
        Map<String, Object> mergedDefinitionMap = this.mapMerger.merge(unmergedDefinitionMaps);
        this.definitions = this.splitByLocale(mergedDefinitionMap);
    }

    private List<LocalizedDummyDefinitions> splitByLocale(Map<String, Object> mergedDefinitionMap) {
        ArrayList<LocalizedDummyDefinitions> localizedDummyDefinitions = new ArrayList<LocalizedDummyDefinitions>();
        mergedDefinitionMap.forEach((locale, subMap) -> localizedDummyDefinitions.add(this.toLocalizedDummyDefinitions((String)locale, subMap)));
        return localizedDummyDefinitions;
    }

    private LocalizedDummyDefinitions toLocalizedDummyDefinitions(String locale, Object map) {
        return new LocalizedDummyDefinitionsMap(locale, (Map)map);
    }
}

