/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.dummies;

import dev.codesoapbox.dummy4j.Dummy4j;
import java.util.ArrayList;

public class LoremDummy {
    private final Dummy4j dummy4j;

    public LoremDummy(Dummy4j dummy4j) {
        this.dummy4j = dummy4j;
    }

    public String characters(int numberOfCharacters) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numberOfCharacters; ++i) {
            builder.append(this.character());
        }
        return builder.toString();
    }

    public String character() {
        return this.dummy4j.getExpressionResolver().resolveKey("lorem.characters");
    }

    public String sentence(int minWords, int maxWords) {
        int numberOfWords = this.dummy4j.random().nextInt(minWords, maxWords);
        return this.sentence(numberOfWords);
    }

    public String sentence(int numberOfWords) {
        String sentence = this.sentenceWithoutPunctuation(numberOfWords);
        return this.capitalize(sentence) + this.sentenceEndingPunctuation();
    }

    private String capitalize(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private String sentenceEndingPunctuation() {
        if (this.dummy4j.random().nextInt(15) > 1) {
            return ".";
        }
        return this.dummy4j.getExpressionResolver().resolveKey("lorem.additional_sentence_ending_punctuation");
    }

    private String sentenceWithoutPunctuation(int numberOfWords) {
        ArrayList<String> elements = new ArrayList<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            elements.add(this.word());
        }
        return String.join((CharSequence)" ", elements);
    }

    public String word() {
        return this.dummy4j.getExpressionResolver().resolveKey("lorem.words");
    }

    public String paragraph() {
        int numberOfParagraphs = this.dummy4j.random().nextInt(3, 10);
        return this.paragraph(numberOfParagraphs);
    }

    public String paragraph(int numberOfSentences) {
        ArrayList<String> sentences = new ArrayList<String>();
        for (int i = 0; i < numberOfSentences; ++i) {
            sentences.add(this.sentence());
        }
        return String.join((CharSequence)" ", sentences);
    }

    public String sentence() {
        int numberOfWords = this.dummy4j.random().nextInt(3, 10);
        return this.sentence(numberOfWords);
    }
}

