/*
 * Decompiled with CFR 0.152.
 */
package dev.codesoapbox.dummy4j.definitions.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapMerger {
    public Map<String, Object> merge(List<Map<String, Object>> definitionMaps) {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        definitionMaps.forEach(otherMap -> this.mergeMap((Map<String, Object>)mergedMap, (Map<String, Object>)otherMap));
        return mergedMap;
    }

    private void mergeMap(Map<String, Object> mergedMap, Map<String, Object> otherMap) {
        otherMap.forEach((key, value) -> this.mergeMapKey(mergedMap, otherMap, (String)key, value));
    }

    private void mergeMapKey(Map<String, Object> mergedMap, Map<String, Object> otherMap, String key, Object value) {
        if (!mergedMap.containsKey(key)) {
            mergedMap.put(key, value);
            return;
        }
        if (mergedMap.get(key) instanceof String) {
            if (otherMap.get(key) instanceof String) {
                mergedMap.put(key, Arrays.asList(mergedMap.get(key), otherMap.get(key)));
            } else {
                List<String> mergedList = this.mergeCollectionWithElement((String)mergedMap.get(key), (Collection)otherMap.get(key));
                mergedMap.put(key, mergedList);
            }
        } else if (mergedMap.get(key) instanceof Map) {
            Map<String, Object> mergedValue = this.mergeMapKeyAsMap(mergedMap, otherMap, key);
            mergedMap.put(key, mergedValue);
        } else if (otherMap.get(key) instanceof String) {
            List<String> mergedList = this.mergeElementWithCollection((String)otherMap.get(key), (Collection)mergedMap.get(key));
            mergedMap.put(key, mergedList);
        } else {
            Object mergedValue = this.mergeMapKeyAsList(mergedMap, otherMap, key);
            mergedMap.put(key, mergedValue);
        }
    }

    private List<String> mergeCollectionWithElement(String string, Collection<String> collection) {
        ArrayList<String> mergedList = new ArrayList<String>();
        mergedList.add(string);
        mergedList.addAll(collection);
        return mergedList;
    }

    private List<String> mergeElementWithCollection(String string, Collection<String> collection) {
        ArrayList<String> mergedList = new ArrayList<String>(collection);
        mergedList.add(string);
        return mergedList;
    }

    private Object mergeMapKeyAsList(Map<String, Object> mergedMap, Map<String, Object> otherMap, String key) {
        Collection mergedMapValue = (Collection)mergedMap.get(key);
        Collection otherMapValue = (Collection)otherMap.get(key);
        return Stream.concat(mergedMapValue.stream(), otherMapValue.stream()).distinct().collect(Collectors.toList());
    }

    private Map<String, Object> mergeMapKeyAsMap(Map<String, Object> mergedMap, Map<String, Object> otherMap, String key) {
        Map mergedMapValue = (Map)mergedMap.get(key);
        Map otherMapValue = (Map)otherMap.get(key);
        return this.merge(Arrays.asList(mergedMapValue, otherMapValue));
    }
}

