/*
 * Decompiled with CFR 0.152.
 */
package dev.codeflush.commons;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Strings {
    private Strings() {
        throw new AssertionError((Object)"No dev.codeflush.commons.Strings instances for you!");
    }

    public static String[] split(String str, char delimiter) {
        return Strings.split(str, delimiter, Collectors.toList()).toArray(new String[0]);
    }

    public static String[] split(String str, String delimiter) {
        return Strings.split(str, delimiter, Collectors.toList()).toArray(new String[0]);
    }

    public static <A, R> R split(String str, char delimiter, Collector<String, A, R> collector) {
        return Strings.split(str, delimiter, (String part) -> true, collector);
    }

    public static <A, R> R split(String str, char delimiter, Predicate<String> continueCondition, Collector<String, A, R> collector) {
        BiConsumer accumulator = collector.accumulator();
        Object container = collector.supplier().get();
        Strings.split(str, delimiter, (String part) -> {
            if (continueCondition.test((String)part)) {
                accumulator.accept(container, (String)part);
                return true;
            }
            return false;
        });
        return collector.finisher().apply(container);
    }

    public static <A, R> R split(String str, String delimiter, Collector<String, A, R> collector) {
        return Strings.split(str, delimiter, (String part) -> true, collector);
    }

    public static <A, R> R split(String str, String delimiter, Predicate<String> continueCondition, Collector<String, A, R> collector) {
        BiConsumer accumulator = collector.accumulator();
        Object container = collector.supplier().get();
        Strings.split(str, delimiter, (String part) -> {
            if (continueCondition.test((String)part)) {
                accumulator.accept(container, (String)part);
                return true;
            }
            return false;
        });
        return collector.finisher().apply(container);
    }

    public static void split(String str, char delimiter, Consumer<String> consumer) {
        Strings.split(str, delimiter, (String part) -> {
            consumer.accept((String)part);
            return true;
        });
    }

    public static void split(String str, char delimiter, ToBooleanFunction<String> consumer) {
        int position;
        int offset = 0;
        boolean shouldContinue = true;
        while (shouldContinue && (position = str.indexOf(delimiter, offset)) != -1) {
            shouldContinue = consumer.apply(str.substring(offset, position));
            offset = position + 1;
        }
        if (shouldContinue) {
            consumer.apply(str.substring(offset));
        }
    }

    public static void split(String str, String delimiter, Consumer<String> consumer) {
        Strings.split(str, delimiter, (String part) -> {
            consumer.accept((String)part);
            return true;
        });
    }

    public static void split(String str, String delimiter, ToBooleanFunction<String> consumer) {
        int position;
        int delimiterLength = delimiter.length();
        int offset = 0;
        boolean shouldContinue = true;
        while (shouldContinue && (position = str.indexOf(delimiter, offset)) != -1) {
            shouldContinue = consumer.apply(str.substring(offset, position));
            offset = position + delimiterLength;
        }
        if (shouldContinue) {
            consumer.apply(str.substring(offset));
        }
    }

    @FunctionalInterface
    public static interface ToBooleanFunction<T> {
        public boolean apply(T var1);
    }
}

