package dev.codeflush.commons;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;

public class Tuple implements Serializable {

    protected final Object[] values;

    protected Tuple(int size) {
        this.values = new Object[size];
    }

    protected <T> T get(int index) {
        return (T) this.values[index];
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (o == null || getClass() != o.getClass()) {
            return false;
        }

        return Arrays.deepEquals(this.values, ((Tuple) o).values);
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode(this.values);
    }

    @Override
    public String toString() {
        return "Tuple(" + Arrays.deepToString(this.values) + ")";
    }

    public static void generateClass(PrintStream out, String pkg, int size) {
        if (size < 2) {
            throw new IllegalArgumentException("size must be >= 2");
        }

        out.println("/*");
        out.println("Auto-Generated class");
        out.println("Do not edit directly");
        out.println("*/");
        out.print("package ");
        out.print(pkg);
        out.println(";");
        out.println();
        out.print("public class Tuple");
        out.print(size);
        out.print("<");

        for (int i = 0; i < size; i++) {
            out.print("T");
            out.print(i);

            if (i < size - 1) {
                out.print(", ");
            }
        }

        out.print("> extends Tuple");
        out.print(size - 1);
        out.print("<");

        for (int i = 0; i < size - 1; i++) {
            out.print("T");
            out.print(i);

            if (i < size - 2) {
                out.print(", ");
            }
        }

        out.println("> {");
        out.println();
        out.println("\tprivate static final long serialVersionUID = 1L;");
        out.println();
        out.print("\tprotected Tuple");
        out.print(size);
        out.print("(int size, ");

        for (int i = 0; i < size; i++) {
            out.print("T");
            out.print(i);
            out.print(" value");
            out.print(i);

            if (i < size - 1) {
                out.print(", ");
            }
        }

        out.println(") {");
        out.print("\t\tsuper(size, ");

        for (int i = 0; i < size - 1; i++) {
            out.print("value");
            out.print(i);

            if (i < size - 2) {
                out.print(", ");
            }
        }

        out.println(");");
        out.print("\t\tthis.values[");
        out.print(size - 1);
        out.print("] = value");
        out.print(size - 1);
        out.println(";");
        out.println("\t}");
        out.println();
        out.print("\tpublic Tuple");
        out.print(size);
        out.print("(");

        for (int i = 0; i < size; i++) {
            out.print("T");
            out.print(i);
            out.print(" value");
            out.print(i);

            if (i < size - 1) {
                out.print(", ");
            }
        }

        out.println(") {");
        out.print("\t\tthis(");
        out.print(size);
        out.print(", ");

        for (int i = 0; i < size; i++) {
            out.print("value");
            out.print(i);

            if (i < size - 1) {
                out.print(", ");
            }
        }

        out.println(");");
        out.println("\t}");
        out.println();
        out.print("\tpublic T");
        out.print(size - 1);
        out.print(" v");
        out.print(size - 1);
        out.println("() {");
        out.print("\t\treturn get(");
        out.print(size - 1);
        out.println(");");
        out.println("\t}");
        out.println("}");
    }
}
