package dev.codeflush.commons;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class CloseCallbackInputStream extends InputStream {

    private final InputStream base;
    private final IORunnable onCloseAction;

    public CloseCallbackInputStream(InputStream base, IORunnable onCloseAction) {
        this.base = Objects.requireNonNull(base);
        this.onCloseAction = Objects.requireNonNull(onCloseAction);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.base.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.base.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.base.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.base.available();
    }

    @Override
    public void close() throws IOException {
        this.base.close();
        this.onCloseAction.run();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.base.reset();
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.base.read();
    }

    @FunctionalInterface
    public interface IORunnable extends ExcRunnable<IOException> { }
}
