/*
 * Decompiled with CFR 0.152.
 */
package dev.codeflush.commons;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Strings {
    private Strings() {
        throw new AssertionError((Object)"No dev.codeflush.commons.Strings instances for you!");
    }

    public static String[] split(String str, char delimiter) {
        return Strings.split(str, delimiter, Collectors.toList()).toArray(new String[0]);
    }

    public static String[] split(String str, String delimiter) {
        return Strings.split(str, delimiter, Collectors.toList()).toArray(new String[0]);
    }

    public static <A, R> R split(String str, char delimiter, Collector<String, A, R> collector) {
        BiConsumer accumulator = collector.accumulator();
        Object container = collector.supplier().get();
        Strings.split(str, delimiter, (String part) -> accumulator.accept(container, (String)part));
        return collector.finisher().apply(container);
    }

    public static <A, R> R split(String str, String delimiter, Collector<String, A, R> collector) {
        BiConsumer accumulator = collector.accumulator();
        Object container = collector.supplier().get();
        Strings.split(str, delimiter, (String part) -> accumulator.accept(container, (String)part));
        return collector.finisher().apply(container);
    }

    public static void split(String str, char delimiter, Consumer<String> consumer) {
        int position;
        int offset = 0;
        while ((position = str.indexOf(delimiter, offset)) != -1) {
            consumer.accept(str.substring(offset, position));
            offset = position + 1;
        }
        consumer.accept(str.substring(offset));
    }

    public static void split(String str, String delimiter, Consumer<String> consumer) {
        int position;
        int delimiterLength = delimiter.length();
        int offset = 0;
        while ((position = str.indexOf(delimiter, offset)) != -1) {
            consumer.accept(str.substring(offset, position));
            offset = position + delimiterLength;
        }
        consumer.accept(str.substring(offset));
    }
}

