package dev.codeflush.commons;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Strings {

    private Strings() {
        throw new AssertionError("No dev.codeflush.commons.Strings instances for you!");
    }

    public static String[] split(String str, char delimiter) {
        return split(str, delimiter, Collectors.toList()).toArray(new String[0]);
    }

    public static String[] split(String str, String delimiter) {
        return split(str, delimiter, Collectors.toList()).toArray(new String[0]);
    }

    public static <A, R> R split(String str, char delimiter, Collector<String, A, R> collector) {
        final BiConsumer<A, String> accumulator = collector.accumulator();
        final A container = collector.supplier().get();

        split(str, delimiter, (part) -> accumulator.accept(container, part));

        return collector.finisher().apply(container);
    }

    public static <A, R> R split(String str, String delimiter, Collector<String, A, R> collector) {
        final BiConsumer<A, String> accumulator = collector.accumulator();
        final A container = collector.supplier().get();

        split(str, delimiter, (part) -> accumulator.accept(container, part));

        return collector.finisher().apply(container);
    }

    public static void split(String str, char delimiter, Consumer<String> consumer) {
        int offset = 0;
        int position;

        while ((position = str.indexOf(delimiter, offset)) != -1) {
            consumer.accept(str.substring(offset, position));
            offset = position + 1;
        }

        consumer.accept(str.substring(offset));
    }

    public static void split(String str, String delimiter, Consumer<String> consumer) {
        final int delimiterLength = delimiter.length();
        int offset = 0;
        int position;

        while ((position = str.indexOf(delimiter, offset)) != -1) {
            consumer.accept(str.substring(offset, position));
            offset = position + delimiterLength;
        }

        consumer.accept(str.substring(offset));
    }
}
