/*
 * Decompiled with CFR 0.152.
 */
package dev.codeflush.baseencoder;

import dev.codeflush.baseencoder.BaseEncoding;

public class SimpleBaseEncoding
implements BaseEncoding {
    private static final int LOOKUP_FACTOR = 100;
    private final char[] chars;
    private final int[][] indexLookup;
    private final int bitBlockSize;

    public SimpleBaseEncoding(String str) {
        this(str.toCharArray());
    }

    public SimpleBaseEncoding(char[] chars) {
        if (chars.length < 2 || !SimpleBaseEncoding.isPowerOfTwo(chars.length)) {
            throw new IllegalArgumentException("chars length must be a power of 2");
        }
        if (SimpleBaseEncoding.containsDuplicates(chars)) {
            throw new IllegalArgumentException("every character must be unique");
        }
        this.chars = chars;
        this.indexLookup = SimpleBaseEncoding.buildLookup(chars);
        this.bitBlockSize = 31 - Integer.numberOfLeadingZeros(chars.length);
    }

    @Override
    public int bitBlockSize() {
        return this.bitBlockSize;
    }

    @Override
    public char get(int index) {
        return this.chars[index];
    }

    @Override
    public int index(char c) {
        return this.indexLookup[c / 100][c % 100];
    }

    private static boolean isPowerOfTwo(int number) {
        return number > 0 && (number & number - 1) == 0;
    }

    private static boolean containsDuplicates(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            for (int j = i + 1; j < chars.length; ++j) {
                if (chars[i] != chars[j]) continue;
                return true;
            }
        }
        return false;
    }

    private static int[][] buildLookup(char[] chars) {
        int[][] lookup = new int[656][];
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            int[] innerLookup = lookup[c / 100];
            if (innerLookup == null) {
                lookup[c / 100] = innerLookup = new int[100];
            }
            innerLookup[c % 100] = i++;
        }
        return lookup;
    }
}

