/*
 * Decompiled with CFR 0.152.
 */
package dev.codeflush.baseencoder;

import dev.codeflush.baseencoder.BaseDecoder;
import dev.codeflush.baseencoder.BaseEncoder;
import dev.codeflush.baseencoder.SimpleBaseEncoding;
import dev.codeflush.baseencoder.compatibility.Deserializer;
import dev.codeflush.baseencoder.compatibility.Serializer;
import dev.codeflush.baseencoder.compatibility.TypedDeserializer;
import dev.codeflush.baseencoder.compatibility.TypedSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;

public interface BaseEncoding {
    public static final BaseEncoding BASE64 = new SimpleBaseEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    public static final BaseEncoding BASE64_WEB = new SimpleBaseEncoding("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
    public static final BaseEncoding BASE32 = new SimpleBaseEncoding("abcdefghijklmnopqrstuvwxyz012345");
    public static final BaseEncoding BASE16 = new SimpleBaseEncoding("0123456789abcdef");
    public static final BaseEncoding BASE8 = new SimpleBaseEncoding("01234567");
    public static final BaseEncoding BASE2 = new SimpleBaseEncoding("01");

    public int bitBlockSize();

    public char get(int var1);

    public int index(char var1);

    default public <IMPL> String encode(IMPL typeInformation, Object obj, Serializer<IMPL> serializer) {
        String result;
        try (StringWriter writer = new StringWriter();){
            try (BaseEncoder out = new BaseEncoder(this, writer);){
                serializer.serialize(typeInformation, obj, out);
            }
            writer.flush();
            result = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    default public <T> String encode(T obj, TypedSerializer<T> serializer) {
        String result;
        try (StringWriter writer = new StringWriter();){
            try (BaseEncoder out = new BaseEncoder(this, writer);){
                serializer.serialize(obj, out);
            }
            writer.flush();
            result = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    default public String encode(String str) {
        return this.encode(str.getBytes());
    }

    default public String encode(String str, Charset charset) {
        return this.encode(str.getBytes(charset));
    }

    default public String encode(byte[] bytes) {
        String result;
        try (StringWriter writer = new StringWriter();){
            try (BaseEncoder out = new BaseEncoder(this, writer);){
                ((OutputStream)out).write(bytes);
            }
            writer.flush();
            result = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    default public <T, IMPL> T decodeObject(IMPL typeInformation, String str, Deserializer<IMPL> deserializer) {
        Object result;
        try (BaseDecoder in = new BaseDecoder(this, new StringReader(str));){
            result = deserializer.deserialize(typeInformation, in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    default public <T> T decodeObject(String str, TypedDeserializer<T> deserializer) {
        T result;
        try (BaseDecoder in = new BaseDecoder(this, new StringReader(str));){
            result = deserializer.deserialize(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    default public String decodeString(String str) {
        StringBuilder result = new StringBuilder();
        try (BaseDecoder in = new BaseDecoder(this, new StringReader(str));){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                result.append(new String(buffer, 0, bytesRead));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    default public String decodeString(String str, Charset charset) {
        StringBuilder result = new StringBuilder();
        try (BaseDecoder in = new BaseDecoder(this, new StringReader(str));){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                result.append(new String(buffer, 0, bytesRead, charset));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    default public byte[] decodeBytes(String str) {
        byte[] result;
        try (BaseDecoder in = new BaseDecoder(this, new StringReader(str));
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            result = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

