/*
 * Decompiled with CFR 0.152.
 */
package dev.codeflush.baseencoder;

import dev.codeflush.baseencoder.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;

public class BaseDecoder
extends InputStream {
    private static final int BUFFER_SIZE = 8192;
    private final BaseEncoding encoding;
    private final Reader in;
    private final CharBuffer buffer;
    private final int maxBytesPerRead;
    private int bitIndex;
    private byte unfinishedByte;

    public BaseDecoder(BaseEncoding encoding, Reader in) {
        this.encoding = encoding;
        this.in = in;
        this.buffer = CharBuffer.allocate(8192);
        this.maxBytesPerRead = BaseDecoder.roundUp(8192 * encoding.bitBlockSize(), 8) / 8;
        this.bitIndex = 0;
        this.unfinishedByte = 0;
    }

    @Override
    public int read() throws IOException {
        byte[] singleByteBuffer = new byte[1];
        if (this.read(singleByteBuffer) == -1) {
            return -1;
        }
        return singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bitsPerChar;
        int bitsReady;
        int totalBitsRequested;
        int bitsLeft;
        int charsToRead;
        if (length > this.maxBytesPerRead) {
            length = this.maxBytesPerRead;
        }
        if ((charsToRead = BaseDecoder.roundUp(bitsLeft = (totalBitsRequested = length * 8) - (bitsReady = this.bitIndex), bitsPerChar = this.encoding.bitBlockSize()) / bitsPerChar) > this.buffer.capacity()) {
            charsToRead = this.buffer.capacity();
        }
        this.buffer.clear();
        this.buffer.limit(charsToRead);
        int actualCharactersRead = this.in.read(this.buffer);
        if (actualCharactersRead == -1) {
            int bytesRead;
            if (this.bitIndex > 0) {
                if (this.unfinishedByte != 0) {
                    buffer[offset] = this.unfinishedByte;
                    bytesRead = 1;
                } else {
                    bytesRead = -1;
                }
                this.unfinishedByte = 0;
                this.bitIndex = 0;
            } else {
                bytesRead = -1;
            }
            return bytesRead;
        }
        int bytesRead = 0;
        for (int i = 0; i < actualCharactersRead; ++i) {
            int charIndex = this.encoding.index(this.buffer.get(i));
            for (int j = this.encoding.bitBlockSize() - 1; j >= 0; --j) {
                if (BaseDecoder.getBit(charIndex, j)) {
                    this.unfinishedByte = (byte)(this.unfinishedByte | 1 << 8 - this.bitIndex - 1);
                }
                ++this.bitIndex;
                if (this.bitIndex < 8) continue;
                buffer[offset + bytesRead] = this.unfinishedByte;
                this.unfinishedByte = 0;
                this.bitIndex = 0;
                ++bytesRead;
            }
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static int roundUp(int num, int roundTo) {
        int mod = num % roundTo;
        if (mod != 0) {
            num += roundTo - mod;
        }
        return num;
    }

    private static boolean getBit(int v, int n) {
        return (v & 1 << n) != 0;
    }
}

