/*
 * Decompiled with CFR 0.152.
 */
package dev.claudio.jpatemporal.repository.support;

import dev.claudio.jpatemporal.repository.TemporalRepository;
import dev.claudio.jpatemporal.repository.impl.TemporalRepositoryImpl;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.NonNull;

public class DefaultRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends JpaRepositoryFactoryBean<T, S, ID> {
    private final boolean isTemporalRepository;

    public DefaultRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
        this.isTemporalRepository = TemporalRepository.class.isAssignableFrom(repositoryInterface);
    }

    @NonNull
    protected RepositoryFactorySupport createRepositoryFactory(@NonNull EntityManager entityManager) {
        return this.isTemporalRepository ? new DefaultRepositoryFactory(entityManager) : super.createRepositoryFactory(entityManager);
    }

    static class DefaultRepositoryFactory
    extends JpaRepositoryFactory {
        DefaultRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
        }

        @NonNull
        protected Class<?> getRepositoryBaseClass(@NonNull RepositoryMetadata metadata) {
            return TemporalRepositoryImpl.class;
        }

        @NonNull
        protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, @NonNull QueryMethodEvaluationContextProvider evaluationContextProvider) {
            return super.getQueryLookupStrategy(QueryLookupStrategy.Key.USE_DECLARED_QUERY, evaluationContextProvider);
        }
    }
}

