/*
 * Decompiled with CFR 0.152.
 */
package dev.claudio.jpatemporal.repository.impl;

import dev.claudio.jpatemporal.repository.TemporalRepository;
import dev.claudio.jpatemporal.repository.impl.AnnotatedEntitySupport;
import dev.claudio.jpatemporal.repository.impl.RevisionMetadataImpl;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.history.Revision;
import org.springframework.data.history.Revisions;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.lang.NonNull;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

@NoRepositoryBean
public class TemporalRepositoryImpl<T, ID>
extends SimpleJpaRepository<T, ID>
implements TemporalRepository<T, ID> {
    private final AnnotatedEntitySupport<T> annotatedEntitySupport;
    private final JpaEntityInformation<T, ID> entityInformation;
    private final EntityManager em;

    public TemporalRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager em) {
        super(entityInformation, em);
        this.entityInformation = entityInformation;
        this.em = em;
        this.annotatedEntitySupport = new AnnotatedEntitySupport(this.getDomainClass());
    }

    @Override
    public Optional<T> findById(@NonNull ID id, @NonNull Instant asOfInstant) {
        return this.findAllById(Collections.singletonList(id), asOfInstant).stream().findFirst();
    }

    @Override
    public List<T> findAllById(@NonNull Iterable<ID> ids, Instant asOfInstant) {
        return super.getQuery(this.inIdSpec(ids).and(this.toAndFromSpecification(asOfInstant)), this.getDomainClass(), Sort.unsorted()).getResultList();
    }

    @Override
    public List<T> findAll(@NonNull Instant asOfInstant) {
        return this.findAll(null, asOfInstant);
    }

    @Override
    public List<T> findAll(Specification<T> spec, @NonNull Instant asOfInstant) {
        return super.getQuery(this.toAndFromSpecification(asOfInstant).and(spec), this.getDomainClass(), Sort.unsorted()).getResultList();
    }

    @Override
    public long count(@NonNull Instant asOfInstant) {
        return this.count(null, asOfInstant);
    }

    @Override
    public long count(Specification<T> spec, @NonNull Instant asOfInstant) {
        return super.getCountQuery(this.toAndFromSpecification(asOfInstant).and(spec), this.getDomainClass()).getResultList().stream().reduce(0L, Long::sum);
    }

    @NonNull
    public Optional<T> findById(@NonNull ID id) {
        return super.findOne((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get(this.annotatedEntitySupport.getUniqueKey()), id));
    }

    public boolean existsById(@NonNull ID id) {
        return this.findById(id).isPresent();
    }

    @NonNull
    public List<T> findAllById(@NonNull Iterable<ID> ids) {
        return this.findAllById(ids, MAX_INSTANT);
    }

    @NonNull
    @Deprecated
    public T getOne(@NonNull ID id) {
        return this.findById(id).orElseThrow(EntityNotFoundException::new);
    }

    public long count() {
        return super.count((Specification)null);
    }

    @NonNull
    @Transactional
    public <S extends T> S save(@NonNull S entity) {
        ID id = this.getIdFromEntity(entity);
        Optional<T> existingEntity = this.findById(id);
        if (existingEntity.isPresent() && existingEntity.get().equals(entity)) {
            return entity;
        }
        Instant currentTime = Instant.now();
        this.deleteById(id, currentTime);
        this.annotatedEntitySupport.setAttribute(this.annotatedEntitySupport.getFromDate(), entity, currentTime);
        this.annotatedEntitySupport.setAttribute(this.annotatedEntitySupport.getToDate(), entity, MAX_INSTANT);
        this.annotatedEntitySupport.setAttribute(this.annotatedEntitySupport.getTemporalId(), entity, null);
        return (S)super.save(entity);
    }

    @NonNull
    public void deleteById(@NonNull ID id) {
        if (this.deleteById(id, Instant.now()) <= 0) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.entityInformation.getJavaType(), id), 1);
        }
    }

    public void delete(@NonNull T entity) {
        ID id = this.getIdFromEntity(entity);
        this.deleteById(id, Instant.now());
    }

    public void deleteAllInBatch() {
        this.deleteByIds(null, Instant.now());
    }

    public void deleteAllInBatch(@NonNull Iterable<T> entities) {
        Set idsToDelete = StreamSupport.stream(entities.spliterator(), false).map(this::getIdFromEntity).collect(Collectors.toSet());
        if (idsToDelete.isEmpty()) {
            return;
        }
        this.deleteByIds(idsToDelete, Instant.now());
    }

    public void deleteAllByIdInBatch(@NonNull Iterable<ID> ids) {
        Set idsToDelete = StreamSupport.stream(ids.spliterator(), false).collect(Collectors.toSet());
        if (idsToDelete.isEmpty()) {
            return;
        }
        this.deleteByIds(idsToDelete, Instant.now());
    }

    @Deprecated
    public void deleteInBatch(@NonNull Iterable<T> entities) {
        this.deleteAllInBatch(entities);
    }

    @NonNull
    protected <S extends T> TypedQuery<S> getQuery(Specification<S> spec, @NonNull Class<S> domainClass, @NonNull Sort sort) {
        Specification & Serializable toDateSpec = (Specification & Serializable)(root, query, criteriaBuilder) -> this.toAndFromPredicate(MAX_INSTANT, root, criteriaBuilder);
        return super.getQuery(toDateSpec.and(spec), domainClass, sort);
    }

    @NonNull
    protected <S extends T> TypedQuery<Long> getCountQuery(Specification<S> spec, @NonNull Class<S> domainClass) {
        Specification & Serializable toDateSpec = (Specification & Serializable)(root, query, criteriaBuilder) -> this.toAndFromPredicate(MAX_INSTANT, root, criteriaBuilder);
        return super.getCountQuery(toDateSpec.and(spec), domainClass);
    }

    @NonNull
    public Optional<Revision<Integer, T>> findLastChangeRevision(@NonNull ID id) {
        List<Revision<Integer, T>> revisions = this.findRevisionsList(id);
        return Optional.ofNullable(revisions.size() > 0 ? revisions.get(revisions.size() - 1) : null);
    }

    @NonNull
    public Revisions<Integer, T> findRevisions(@NonNull ID id) {
        return Revisions.of(this.findRevisionsList(id));
    }

    @NonNull
    public Page<Revision<Integer, T>> findRevisions(@NonNull ID id, @NonNull Pageable pageable) {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    @NonNull
    public Optional<Revision<Integer, T>> findRevision(@NonNull ID id, @NonNull Integer revisionNumber) {
        List<Revision<Integer, T>> revisions = this.findRevisionsList(id);
        return Optional.ofNullable(revisionNumber > 0 && revisions.size() >= revisionNumber ? revisions.get(revisionNumber - 1) : null);
    }

    @NonNull
    protected Specification<T> inIdSpec(@NonNull Iterable<ID> ids) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> this.inIdPredicate(ids, root, criteriaBuilder);
    }

    @NonNull
    protected Predicate inIdPredicate(@NonNull Iterable<ID> ids, Root<? extends T> root, CriteriaBuilder criteriaBuilder) {
        CriteriaBuilder.In inClause = criteriaBuilder.in((Expression)root.get(this.annotatedEntitySupport.getUniqueKey()));
        ids.forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
        return inClause;
    }

    @NonNull
    protected Specification<T> toAndFromSpecification(Instant asOfInstant) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> this.toAndFromPredicate(asOfInstant, root, criteriaBuilder);
    }

    @NonNull
    protected Predicate toAndFromPredicate(Instant asOfInstant, Root<? extends T> root, CriteriaBuilder criteriaBuilder) {
        if (asOfInstant == null) {
            return criteriaBuilder.conjunction();
        }
        if (asOfInstant.equals(MAX_INSTANT)) {
            return criteriaBuilder.equal((Expression)root.get(this.annotatedEntitySupport.getToDate()), (Object)MAX_INSTANT);
        }
        return criteriaBuilder.and((Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get(this.annotatedEntitySupport.getFromDate()), (Comparable)asOfInstant), (Expression)criteriaBuilder.greaterThan((Expression)root.get(this.annotatedEntitySupport.getToDate()), (Comparable)asOfInstant));
    }

    protected ID getIdFromEntity(T entity) {
        return (ID)this.annotatedEntitySupport.getAttribute(this.annotatedEntitySupport.getUniqueKey(), entity);
    }

    protected int deleteById(ID id, Instant currentTime) {
        if (id == null) {
            throw new JpaSystemException(new RuntimeException("ids for this class must be manually assigned before calling save/delete: " + this.getDomainClass().getName()));
        }
        return this.deleteByIds(Collections.singleton(id), currentTime);
    }

    protected int deleteByIds(Set<ID> ids, Instant currentTime) {
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(this.getDomainClass());
        Root root = criteriaUpdate.from(this.getDomainClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(this.toAndFromPredicate(MAX_INSTANT, root, criteriaBuilder));
        if (ids != null) {
            predicates.add(this.inIdPredicate(ids, root, criteriaBuilder));
        }
        criteriaUpdate.set(root.get(this.annotatedEntitySupport.getToDate()), (Object)currentTime).where(predicates.toArray(new Predicate[0]));
        return this.em.createQuery(criteriaUpdate).executeUpdate();
    }

    protected List<Revision<Integer, T>> findRevisionsList(@NonNull ID id) {
        List<T> allByIdAsOf = this.findAllById(Collections.singletonList(id), null);
        ArrayList<Revision<Integer, T>> metadataList = new ArrayList<Revision<Integer, T>>();
        for (int i = 0; i < allByIdAsOf.size(); ++i) {
            T entity = allByIdAsOf.get(i);
            Instant timestamp = (Instant)this.annotatedEntitySupport.getAttribute(this.annotatedEntitySupport.getFromDate(), entity);
            RevisionMetadataImpl<T, Integer> metadata = new RevisionMetadataImpl<T, Integer>(entity, i + 1, timestamp);
            metadataList.add(Revision.of(metadata, entity));
        }
        return metadataList;
    }
}

