/*
 * Decompiled with CFR 0.152.
 */
package dev.claudio.jpatemporal.repository.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static String fetchAnnotatedField(Class<?> domainClass, Class<? extends Annotation> annotation) {
        Optional<Column> columnAnnotation;
        String fieldName;
        List<Field> annotatedFields = ReflectionUtils.fetchAnnotatedFields(domainClass, annotation);
        List<Method> annotatedMethods = ReflectionUtils.fetchAnnotatedMethods(domainClass, annotation);
        if (annotatedFields.size() + annotatedMethods.size() != 1) {
            if (domainClass.getSuperclass() != null) {
                return ReflectionUtils.fetchAnnotatedField(domainClass.getSuperclass(), annotation);
            }
            throw new RuntimeException("Should have a single annotation '" + annotation.getSimpleName() + "' on " + domainClass + " or its child");
        }
        if (annotatedFields.isEmpty()) {
            fieldName = annotatedMethods.get(0).getName();
            fieldName = fieldName.startsWith("get") ? fieldName.replaceFirst("get", "").toLowerCase(Locale.ROOT) : fieldName;
            columnAnnotation = Optional.ofNullable(annotatedMethods.get(0).getAnnotation(Column.class));
        } else {
            fieldName = annotatedFields.get(0).getName();
            columnAnnotation = Optional.ofNullable(annotatedFields.get(0).getAnnotation(Column.class));
        }
        return columnAnnotation.map(Column::name).filter(it -> !it.isEmpty()).orElse(fieldName);
    }

    public static List<Method> fetchAnnotatedMethods(Class<?> domainClass, Class<? extends Annotation> annotation) {
        return Arrays.stream(domainClass.getDeclaredMethods()).filter(it -> it.getAnnotation(annotation) != null).collect(Collectors.toList());
    }

    public static List<Field> fetchAnnotatedFields(Class<?> domainClass, Class<? extends Annotation> annotation) {
        return Arrays.stream(domainClass.getDeclaredFields()).filter(it -> it.getAnnotation(annotation) != null).collect(Collectors.toList());
    }

    public static Field getField(String attribute, Class<?> entity) throws NoSuchFieldException {
        return Optional.ofNullable(org.springframework.data.util.ReflectionUtils.findField(entity, field -> attribute.equals(field.getName()))).orElseThrow(NoSuchFieldException::new);
    }
}

