/*
 * Decompiled with CFR 0.152.
 */
package dev.claudio.jpatemporal.repository.impl;

import dev.claudio.jpatemporal.annotation.FromDate;
import dev.claudio.jpatemporal.annotation.TemporalId;
import dev.claudio.jpatemporal.annotation.ToDate;
import dev.claudio.jpatemporal.annotation.UniqueKey;
import dev.claudio.jpatemporal.repository.impl.ReflectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

class AnnotatedEntitySupport<T> {
    private static final Set<Class<? extends Annotation>> RELATIONAL_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(OneToOne.class, OneToMany.class, ManyToOne.class, ManyToMany.class)));
    private static final int MANDATORY_ANNOTATIONS_COUNT = 4;
    private final Map<String, Function<T, Object>> readMethod = new HashMap<String, Function<T, Object>>();
    private final Map<String, BiConsumer<T, Object>> writeMethod = new HashMap<String, BiConsumer<T, Object>>();
    private final String uniqueKey;
    private final String temporalId;
    private final String fromDate;
    private final String toDate;

    AnnotatedEntitySupport(Class<T> domainClass) {
        this.validateNoRelationalAnnotations(domainClass);
        this.uniqueKey = ReflectionUtils.fetchAnnotatedField(domainClass, UniqueKey.class);
        this.temporalId = ReflectionUtils.fetchAnnotatedField(domainClass, TemporalId.class);
        this.fromDate = ReflectionUtils.fetchAnnotatedField(domainClass, FromDate.class);
        this.toDate = ReflectionUtils.fetchAnnotatedField(domainClass, ToDate.class);
        try {
            Arrays.stream(Introspector.getBeanInfo(domainClass, Object.class).getPropertyDescriptors()).filter(it -> Arrays.asList(this.uniqueKey, this.temporalId, this.fromDate, this.toDate).contains(it.getName())).forEach(it -> {
                this.readMethod.put(it.getName(), this.createGetterFunction((PropertyDescriptor)it));
                this.writeMethod.put(it.getName(), this.createSetterFunction((PropertyDescriptor)it));
            });
            if (this.readMethod.size() != 4 || this.writeMethod.size() != 4) {
                throw new RuntimeException("Could not correctly identify property getters/setters for " + domainClass);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not create PropertyDescriptors for " + domainClass, e);
        }
    }

    public Object getAttribute(String attribute, T entity) {
        return this.readMethod.get(attribute).apply(entity);
    }

    public void setAttribute(String attribute, T entity, Object value) {
        this.writeMethod.get(attribute).accept(entity, value);
    }

    private void validateNoRelationalAnnotations(Class<?> domainClass) {
        boolean hasRelationalAnnotations = RELATIONAL_ANNOTATIONS.stream().anyMatch(annotation -> ReflectionUtils.fetchAnnotatedMethods(domainClass, annotation).size() + ReflectionUtils.fetchAnnotatedFields(domainClass, annotation).size() > 0);
        if (hasRelationalAnnotations) {
            throw new RuntimeException("Relational Annotations are not supported: " + RELATIONAL_ANNOTATIONS);
        }
    }

    private ThrowingFunction<T, Object> createGetterFunction(PropertyDescriptor it) {
        return it.getReadMethod() != null ? entity -> it.getReadMethod().invoke(entity, new Object[0]) : entity -> ReflectionUtils.getField(it.getName(), entity.getClass()).get(entity);
    }

    private ThrowingConsumer<T, Object> createSetterFunction(PropertyDescriptor it) {
        return it.getWriteMethod() != null ? (entity, value) -> it.getWriteMethod().invoke(entity, value) : (entity, value) -> ReflectionUtils.getField(it.getName(), entity.getClass()).set(entity, value);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getUniqueKey() {
        return this.uniqueKey;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getTemporalId() {
        return this.temporalId;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getFromDate() {
        return this.fromDate;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getToDate() {
        return this.toDate;
    }

    @FunctionalInterface
    static interface ThrowingFunction<T, U>
    extends Function<T, U> {
        @Override
        default public U apply(T elem) {
            try {
                return this.applyThrows(elem);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not apply '%s'", elem), e);
            }
        }

        public U applyThrows(T var1) throws Exception;
    }

    @FunctionalInterface
    static interface ThrowingConsumer<T, U>
    extends BiConsumer<T, U> {
        @Override
        default public void accept(T elem, U elem2) {
            try {
                this.acceptThrows(elem, elem2);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not accept '%s' with '%s'", elem, elem2), e);
            }
        }

        public void acceptThrows(T var1, U var2) throws Exception;
    }
}

