(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-firebase-admin'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-firebase-admin'.");
    }root['kotlin-firebase-admin'] = factory(typeof this['kotlin-firebase-admin'] === 'undefined' ? {} : this['kotlin-firebase-admin'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var to = Kotlin.kotlin.to_ujzrz7$;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var Any = Object;
  var throwCCE = Kotlin.throwCCE;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  function file($receiver, name, resumable) {
    return $receiver.file(name, json([to('uploadType', json([to('resumable', resumable)]))]));
  }
  function setData($receiver, data, merge) {
    return $receiver.set(data, json([to('merge', merge)]));
  }
  function setValues($receiver, pairs) {
    return $receiver.set(json(pairs.slice()));
  }
  function updateValues($receiver, pairs) {
    return $receiver.update(json(pairs.slice()));
  }
  function getValue($receiver, field) {
    var tmp$;
    return Kotlin.isType(tmp$ = $receiver.get(field), Any) ? tmp$ : throwCCE();
  }
  function save($receiver, data, resumable, contentType) {
    var options = json([to('resumable', resumable), to('metadata', json([to('contentType', contentType)]))]);
    return $receiver.save(data, options);
  }
  function QueryDirection() {
    QueryDirection_instance = this;
    this.DESCENDING = 'desc';
    this.ASCENDING = 'asc';
  }
  QueryDirection.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'QueryDirection',
    interfaces: []
  };
  var QueryDirection_instance = null;
  function QueryDirection_getInstance() {
    if (QueryDirection_instance === null) {
      new QueryDirection();
    }return QueryDirection_instance;
  }
  function whereEqualTo($receiver, field, value) {
    return $receiver.where(field, '==', value);
  }
  function whereArrayContains($receiver, field, value) {
    return $receiver.where(field, 'array-contains', value);
  }
  function whereArrayContainsAny($receiver, field, value) {
    return $receiver.where(field, 'array-contains-any', value);
  }
  function whereIn($receiver, field, value) {
    return $receiver.where(field, 'in', value);
  }
  function whereNotIn($receiver, field, value) {
    return $receiver.where(field, 'not-in', value);
  }
  function whereNotEqualTo($receiver, field, value) {
    return $receiver.where(field, '!=', value);
  }
  function whereGreaterThan($receiver, field, value) {
    return $receiver.where(field, '>', value);
  }
  function whereGreaterEqualsTo($receiver, field, value) {
    return $receiver.where(field, '>=', value);
  }
  function whereLesserThan($receiver, field, value) {
    return $receiver.where(field, '<', value);
  }
  function whereLesserEqualsTo($receiver, field, value) {
    return $receiver.where(field, '<=', value);
  }
  function SetOption() {
    SetOption_instance = this;
  }
  SetOption.prototype.merge_6taknv$ = function (enable) {
    if (enable === void 0)
      enable = true;
    return json([to('merge', enable)]);
  };
  SetOption.prototype.mergeFields_vqirvp$ = function (fieldNames) {
    return json([to('mergeFields', fieldNames)]);
  };
  SetOption.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SetOption',
    interfaces: []
  };
  var SetOption_instance = null;
  function SetOption_getInstance() {
    if (SetOption_instance === null) {
      new SetOption();
    }return SetOption_instance;
  }
  function get_isAnonymous($receiver) {
    return $receiver.providerData.length === 0;
  }
  function setData_0($receiver, documentRef, data, merge) {
    return $receiver.set(documentRef, data, json([to('merge', merge)]));
  }
  function setData_1($receiver, documentRef, data, mergeFields) {
    return $receiver.set(documentRef, data, json([to('mergeFields', mergeFields)]));
  }
  var package$firebase = _.firebase || (_.firebase = {});
  package$firebase.file_i612yv$ = file;
  package$firebase.setData_nuv1rl$ = setData;
  package$firebase.setValues_4wr2e$ = setValues;
  package$firebase.updateValues_4wr2e$ = updateValues;
  package$firebase.getValue_fl41ng$ = getValue;
  package$firebase.save_3wkmt$ = save;
  Object.defineProperty(package$firebase, 'QueryDirection', {
    get: QueryDirection_getInstance
  });
  package$firebase.whereEqualTo_7gn9ln$ = whereEqualTo;
  package$firebase.whereArrayContains_7gn9ln$ = whereArrayContains;
  package$firebase.whereArrayContainsAny_qvmxvv$ = whereArrayContainsAny;
  package$firebase.whereIn_qvmxvv$ = whereIn;
  package$firebase.whereNotIn_qvmxvv$ = whereNotIn;
  package$firebase.whereNotEqualTo_7gn9ln$ = whereNotEqualTo;
  package$firebase.whereGreaterThan_7gn9ln$ = whereGreaterThan;
  package$firebase.whereGreaterEqualsTo_7gn9ln$ = whereGreaterEqualsTo;
  package$firebase.whereLesserThan_7gn9ln$ = whereLesserThan;
  package$firebase.whereLesserEqualsTo_7gn9ln$ = whereLesserEqualsTo;
  Object.defineProperty(package$firebase, 'SetOption', {
    get: SetOption_getInstance
  });
  package$firebase.get_isAnonymous_5old5g$ = get_isAnonymous;
  package$firebase.setData_srm0nn$ = setData_0;
  package$firebase.setData_t3r08d$ = setData_1;
  Kotlin.defineModule('kotlin-firebase-admin', _);
  return _;
}));

//# sourceMappingURL=kotlin-firebase-admin.js.map
