/*
 * Decompiled with CFR 0.152.
 */
package dev.chopsticks.kvdb.fdb;

import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import dev.chopsticks.kvdb.ColumnFamily;
import dev.chopsticks.kvdb.KvdbWriteTransactionBuilder;
import dev.chopsticks.kvdb.fdb.FdbDatabase;
import dev.chopsticks.kvdb.fdb.FdbReadApi;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\t\u0012\u0005iA\u0001B\u000f\u0001\u0003\u0006\u0004%\te\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005y!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013Y\u0006\"B0\u0001\t\u0003\u0001\u0007B\u00024\u0001\t\u0003)r\rC\u0004\u0000\u0001\u0011\u0005Q#!\u0001\t\u0011\u0005\u001d\u0001\u0001\"\u0001\u0016\u0003\u0013A\u0001\"!\u0005\u0001\t\u0003)\u00121\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\tYa\t\u001a2Xe&$X-\u00119j\u0015\t\u00112#A\u0002gI\nT!\u0001F\u000b\u0002\t-4HM\u0019\u0006\u0003-]\t!b\u00195paN$\u0018nY6t\u0015\u0005A\u0012a\u00013fm\u000e\u0001QCA\u000e#'\t\u0001A\u0004E\u0002\u001e=\u0001j\u0011!E\u0005\u0003?E\u0011!B\u00123c%\u0016\fG-\u00119j!\t\t#\u0005\u0004\u0001\u0005\u000b\r\u0002!\u0019\u0001\u0013\u0003\u0007\t\u001be)F\u0002&ca\n\"A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000f9{G\u000f[5oOB!QF\f\u00198\u001b\u0005\u0019\u0012BA\u0018\u0014\u00051\u0019u\u000e\\;n]\u001a\u000bW.\u001b7z!\t\t\u0013\u0007B\u00033E\t\u00071GA\u0001B#\t1C\u0007\u0005\u0002(k%\u0011a\u0007\u000b\u0002\u0004\u0003:L\bCA\u00119\t\u0015I$E1\u00014\u0005\u0005\u0011\u0015A\u0001;y+\u0005a\u0004CA\u001fE\u001b\u0005q$BA A\u000311w.\u001e8eCRLwN\u001c3c\u0015\t\t%)A\u0003baBdWMC\u0001D\u0003\r\u0019w.\\\u0005\u0003\u000bz\u00121\u0002\u0016:b]N\f7\r^5p]\u0006\u0019A\u000f\u001f\u0011\u0002\u0013\u0011\u00147i\u001c8uKb$\bcA%XA9\u0011!*\u0016\b\u0003\u0017Rs!\u0001T*\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)\u001a\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002\u0017/%\u0011A#F\u0005\u0003%MI!AV\t\u0002\u0017\u0019#'\rR1uC\n\f7/Z\u0005\u00031f\u0013!B\u00123c\u0007>tG/\u001a=u\u0015\t1\u0016#\u0001\u000feSN\f'\r\\3Xe&$XmQ8oM2L7\r^\"iK\u000e\\\u0017N\\4\u0011\u0005\u001db\u0016BA/)\u0005\u001d\u0011un\u001c7fC:\f\u0001#^:f':\f\u0007o\u001d5piJ+\u0017\rZ:\u0002\rqJg.\u001b;?)\u0015\t'm\u00193f!\ri\u0002\u0001\t\u0005\u0006u\u0019\u0001\r\u0001\u0010\u0005\u0006\u000f\u001a\u0001\r\u0001\u0013\u0005\u00065\u001a\u0001\ra\u0017\u0005\u0006=\u001a\u0001\raW\u0001\u000eaV$()_\"pYVlg.\u00133\u0015\t!\\W/ \t\u0003O%L!A\u001b\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\u001e\u0001\r!\\\u0001\tG>dW/\u001c8JIB\u0011aN\u001d\b\u0003_B\u0004\"A\u0014\u0015\n\u0005ED\u0013A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!\u001d\u0015\t\u000bY<\u0001\u0019A<\u0002\u0007-,\u0017\u0010E\u0002(qjL!!\u001f\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001dZ\u0018B\u0001?)\u0005\u0011\u0011\u0015\u0010^3\t\u000by<\u0001\u0019A<\u0002\u000bY\fG.^3\u0002!\u0011,G.\u001a;f\u0005f\u001cu\u000e\\;n]&#G#\u00025\u0002\u0004\u0005\u0015\u0001\"\u00027\t\u0001\u0004i\u0007\"\u0002<\t\u0001\u00049\u0018A\u00063fY\u0016$X\r\u0015:fM&D()_\"pYVlg.\u00133\u0015\u000b!\fY!!\u0004\t\u000b1L\u0001\u0019A7\t\r\u0005=\u0011\u00021\u0001x\u0003\u0019\u0001(/\u001a4jq\u0006)B-\u001a7fi\u0016\u0014\u0016M\\4f\u0005f\u001cu\u000e\\;n]&#Gc\u00025\u0002\u0016\u0005]\u00111\u0004\u0005\u0006Y*\u0001\r!\u001c\u0005\u0007\u00033Q\u0001\u0019A<\u0002\t\u0019\u0014x.\u001c\u0005\u0007\u0003;Q\u0001\u0019A<\u0002\u0005Q|\u0017a\u00019viV!\u00111EA\u0016)\u001dA\u0017QEA\u001d\u0003wAq!a\n\f\u0001\u0004\tI#\u0001\u0004d_2,XN\u001c\t\u0004C\u0005-BaBA\u0017\u0017\t\u0007\u0011q\u0006\u0002\u0004\u0007>d\u0017c\u0001\u0014\u00022A!\u00111GA\u001b\u001b\u0005\u0001\u0011bAA\u001c=\t\u00111I\u0012\u0005\u0006m.\u0001\ra\u001e\u0005\u0006}.\u0001\ra^\u0001\u0007I\u0016dW\r^3\u0016\t\u0005\u0005\u0013q\t\u000b\u0006Q\u0006\r\u0013\u0011\n\u0005\b\u0003Oa\u0001\u0019AA#!\r\t\u0013q\t\u0003\b\u0003[a!\u0019AA\u0018\u0011\u00151H\u00021\u0001x\u00031!W\r\\3uKB\u0013XMZ5y+\u0011\ty%!\u0016\u0015\u000b!\f\t&a\u0016\t\u000f\u0005\u001dR\u00021\u0001\u0002TA\u0019\u0011%!\u0016\u0005\u000f\u00055RB1\u0001\u00020!1\u0011qB\u0007A\u0002]\f\u0011\u0003Z3mKR,'+\u00198hKB\u0013XMZ5y+\u0011\ti&a\u0019\u0015\u000f!\fy&!\u001a\u0002h!9\u0011q\u0005\bA\u0002\u0005\u0005\u0004cA\u0011\u0002d\u00119\u0011Q\u0006\bC\u0002\u0005=\u0002BBA\r\u001d\u0001\u0007q\u000f\u0003\u0004\u0002\u001e9\u0001\ra^\u0001\tiJ\fgn]1diR\u0019\u0001.!\u001c\t\u000f\u0005=t\u00021\u0001\u0002r\u00059\u0011m\u0019;j_:\u001c\bCBA:\u0003{\n\u0019I\u0004\u0003\u0002v\u0005edb\u0001(\u0002x%\t\u0011&C\u0002\u0002|!\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\u0005\u0005%aA*fc*\u0019\u00111\u0010\u0015\u0011\t\u0005\u0015\u00151\u0012\b\u0004\u0017\u0006\u001d\u0015bAAE'\u0005Y2J\u001e3c/JLG/\u001a+sC:\u001c\u0018m\u0019;j_:\u0014U/\u001b7eKJLA!!$\u0002\u0010\n\u0001BK]1og\u0006\u001cG/[8o/JLG/\u001a\u0006\u0004\u0003\u0013\u001b\u0002")
public final class FdbWriteApi<BCF extends ColumnFamily<Object, Object>>
extends FdbReadApi<BCF> {
    private final Transaction tx;
    private final FdbDatabase.FdbContext<BCF> dbContext;
    private final boolean disableWriteConflictChecking;

    public Transaction tx() {
        return this.tx;
    }

    public void putByColumnId(String columnId, byte[] key, byte[] value) {
        byte[] prefixedKey = this.dbContext.prefixKey(columnId, key);
        if (this.disableWriteConflictChecking) {
            this.tx().options().setNextWriteNoWriteConflictRange();
        }
        if (this.dbContext.hasVersionstampKey(columnId)) {
            this.tx().mutate(MutationType.SET_VERSIONSTAMPED_KEY, this.dbContext.adjustKeyVersionstamp(columnId, prefixedKey), value);
            return;
        }
        if (this.dbContext.hasVersionstampValue(columnId)) {
            this.tx().mutate(MutationType.SET_VERSIONSTAMPED_VALUE, prefixedKey, value);
            return;
        }
        this.tx().set(prefixedKey, value);
    }

    public void deleteByColumnId(String columnId, byte[] key) {
        byte[] prefixedKey = this.dbContext.prefixKey(columnId, key);
        if (this.disableWriteConflictChecking) {
            this.tx().options().setNextWriteNoWriteConflictRange();
        }
        this.tx().clear(prefixedKey);
    }

    public void deletePrefixByColumnId(String columnId, byte[] prefix) {
        byte[] prefixedKey = this.dbContext.prefixKey(columnId, prefix);
        if (this.disableWriteConflictChecking) {
            this.tx().options().setNextWriteNoWriteConflictRange();
        }
        this.tx().clear(Range.startsWith((byte[])prefixedKey));
    }

    public void deleteRangeByColumnId(String columnId, byte[] from, byte[] to) {
        if (this.disableWriteConflictChecking) {
            this.tx().options().setNextWriteNoWriteConflictRange();
        }
        this.tx().clear(this.dbContext.prefixKey(columnId, from), this.dbContext.prefixKey(columnId, to));
    }

    public <Col extends BCF> void put(Col column, byte[] key, byte[] value) {
        this.putByColumnId(column.id(), key, value);
    }

    public <Col extends BCF> void delete(Col column, byte[] key) {
        this.deleteByColumnId(column.id(), key);
    }

    public <Col extends BCF> void deletePrefix(Col column, byte[] prefix) {
        this.deletePrefixByColumnId(column.id(), prefix);
    }

    public <Col extends BCF> void deleteRangePrefix(Col column, byte[] from, byte[] to) {
        this.deleteRangeByColumnId(column.id(), from, to);
    }

    public void transact(Seq<KvdbWriteTransactionBuilder.TransactionWrite> actions) {
        actions.foreach((Function1 & Serializable)x0$1 -> {
            FdbWriteApi.$anonfun$transact$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$transact$1(FdbWriteApi $this, KvdbWriteTransactionBuilder.TransactionWrite x0$1) {
        KvdbWriteTransactionBuilder.TransactionWrite transactionWrite = x0$1;
        if (transactionWrite instanceof KvdbWriteTransactionBuilder.TransactionPut) {
            KvdbWriteTransactionBuilder.TransactionPut transactionPut = (KvdbWriteTransactionBuilder.TransactionPut)transactionWrite;
            String columnId = transactionPut.columnId();
            byte[] key = transactionPut.key();
            byte[] value = transactionPut.value();
            $this.putByColumnId(columnId, key, value);
            return;
        }
        if (transactionWrite instanceof KvdbWriteTransactionBuilder.TransactionDelete) {
            KvdbWriteTransactionBuilder.TransactionDelete transactionDelete = (KvdbWriteTransactionBuilder.TransactionDelete)transactionWrite;
            String columnId = transactionDelete.columnId();
            byte[] key = transactionDelete.key();
            $this.deleteByColumnId(columnId, key);
            return;
        }
        if (transactionWrite instanceof KvdbWriteTransactionBuilder.TransactionDeleteRange) {
            KvdbWriteTransactionBuilder.TransactionDeleteRange transactionDeleteRange = (KvdbWriteTransactionBuilder.TransactionDeleteRange)transactionWrite;
            String columnId = transactionDeleteRange.columnId();
            byte[] fromKey = transactionDeleteRange.fromKey();
            byte[] toKey = transactionDeleteRange.toKey();
            $this.deleteRangeByColumnId(columnId, fromKey, toKey);
            return;
        }
        if (transactionWrite instanceof KvdbWriteTransactionBuilder.TransactionMutateAdd) {
            KvdbWriteTransactionBuilder.TransactionMutateAdd transactionMutateAdd = (KvdbWriteTransactionBuilder.TransactionMutateAdd)transactionWrite;
            String columnId = transactionMutateAdd.columnId();
            byte[] key = transactionMutateAdd.key();
            byte[] value = transactionMutateAdd.value();
            $this.tx().mutate(MutationType.ADD, $this.dbContext.prefixKey(columnId, key), value);
            return;
        }
        throw new MatchError((Object)transactionWrite);
    }

    public FdbWriteApi(Transaction tx, FdbDatabase.FdbContext<BCF> dbContext, boolean disableWriteConflictChecking, boolean useSnapshotReads) {
        this.tx = tx;
        this.dbContext = dbContext;
        this.disableWriteConflictChecking = disableWriteConflictChecking;
        super((ReadTransaction)(useSnapshotReads ? tx.snapshot() : tx), dbContext);
    }
}

