/*
 * Decompiled with CFR 0.152.
 */
package dev.chopsticks.kvdb.codec;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import com.apple.foundationdb.tuple.Versionstamp;
import dev.chopsticks.kvdb.codec.FdbKeyCoproductTag;
import dev.chopsticks.kvdb.codec.FdbKeyDeserializer;
import dev.chopsticks.kvdb.codec.FdbTupleReader;
import dev.chopsticks.kvdb.codec.KeyDeserializer;
import dev.chopsticks.kvdb.util.KvdbSerdesUtils$;
import enumeratum.Enum;
import enumeratum.EnumEntry;
import enumeratum.values.ByteEnum;
import enumeratum.values.ByteEnumEntry;
import enumeratum.values.IntEnum;
import enumeratum.values.IntEnumEntry;
import enumeratum.values.ShortEnum;
import enumeratum.values.ShortEnumEntry;
import eu.timepit.refined.api.RefType;
import eu.timepit.refined.api.Validate;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.YearMonth;
import java.util.UUID;
import magnolia.CaseClass;
import magnolia.SealedTrait;
import magnolia.Subtype;
import mercator.Monadic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scalapb.GeneratedEnum;
import scalapb.GeneratedEnumCompanion;
import shapeless.Typeable;
import shapeless.Typeable$;

public final class FdbKeyDeserializer$ {
    public static final FdbKeyDeserializer$ MODULE$ = new FdbKeyDeserializer$();
    private static final FdbKeyDeserializer<String> stringFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$1 -> x$1.getString(), Typeable$.MODULE$.namedSimpleTypeable(String.class, (Function0 & Serializable)() -> "String"));
    private static final FdbKeyDeserializer<Object> intFdbKeyDecoder;
    private static final FdbKeyDeserializer<Object> longFdbKeyDecoder;
    private static final FdbKeyDeserializer<Object> byteFdbKeyDecoder;
    private static final FdbKeyDeserializer<Object> shortFdbKeyDecoder;
    private static final FdbKeyDeserializer<Object> doubleFdbKeyDecoder;
    private static final FdbKeyDeserializer<Object> floatFdbKeyDecoder;
    private static final FdbKeyDeserializer<Object> booleanFdbKeyDecoder;
    private static final FdbKeyDeserializer<ArraySeq<Object>> byteArraySeqFdbKeyDecoder;
    private static final FdbKeyDeserializer<LocalDate> ldFdbKeyDecoder;
    private static final FdbKeyDeserializer<LocalTime> ltFdbKeyDecoder;
    private static final FdbKeyDeserializer<YearMonth> ymFdbKeyDecoder;
    private static final FdbKeyDeserializer<Instant> instantFdbKeyDecoder;
    private static final FdbKeyDeserializer<UUID> uuidFdbKeyDecoder;
    private static final FdbKeyDeserializer<Versionstamp> versionstampFdbKeyDecoder;
    private static volatile int bitmap$init$0;

    static {
        bitmap$init$0 |= 1;
        intFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)FdbKeyDeserializer$.$anonfun$intFdbKeyDecoder$1(x$2)), Typeable$.MODULE$.intTypeable());
        bitmap$init$0 |= 2;
        longFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)FdbKeyDeserializer$.$anonfun$longFdbKeyDecoder$1(x$3)), Typeable$.MODULE$.longTypeable());
        bitmap$init$0 |= 4;
        byteFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$4 -> BoxesRunTime.boxToByte((byte)FdbKeyDeserializer$.$anonfun$byteFdbKeyDecoder$1(x$4)), Typeable$.MODULE$.byteTypeable());
        bitmap$init$0 |= 8;
        shortFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$5 -> BoxesRunTime.boxToShort((short)FdbKeyDeserializer$.$anonfun$shortFdbKeyDecoder$1(x$5)), Typeable$.MODULE$.shortTypeable());
        bitmap$init$0 |= 0x10;
        doubleFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6.getDouble()), Typeable$.MODULE$.doubleTypeable());
        bitmap$init$0 |= 0x20;
        floatFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$7 -> BoxesRunTime.boxToFloat((float)x$7.getFloat()), Typeable$.MODULE$.floatTypeable());
        bitmap$init$0 |= 0x40;
        booleanFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.getBoolean()), Typeable$.MODULE$.booleanTypeable());
        bitmap$init$0 |= 0x80;
        byteArraySeqFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)t -> ArraySeq$.MODULE$.unsafeWrapArray((Object)t.getBytes()), Typeable$.MODULE$.genTraversableTypeable(ClassTag$.MODULE$.apply(ArraySeq.class), Typeable$.MODULE$.byteTypeable()));
        bitmap$init$0 |= 0x100;
        ldFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)t -> {
            long epochDay = t.getLong();
            return LocalDate.ofEpochDay(epochDay);
        }, Typeable$.MODULE$.namedSimpleTypeable(LocalDate.class, (Function0 & Serializable)() -> "LocalDate"));
        bitmap$init$0 |= 0x200;
        ltFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)t -> {
            long nanoOfDay = t.getLong();
            return LocalTime.ofNanoOfDay(nanoOfDay);
        }, Typeable$.MODULE$.namedSimpleTypeable(LocalTime.class, (Function0 & Serializable)() -> "LocalTime"));
        bitmap$init$0 |= 0x400;
        ymFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)t -> {
            YearMonth yearMonth;
            long v = t.getLong();
            if (v == 0L) {
                yearMonth = YearMonth.of(0, 1);
            } else {
                long year = v / 100L;
                long month = v - year * 100L;
                yearMonth = YearMonth.of((int)year, (int)month);
            }
            return yearMonth;
        }, Typeable$.MODULE$.namedSimpleTypeable(YearMonth.class, (Function0 & Serializable)() -> "YearMonth"));
        bitmap$init$0 |= 0x800;
        instantFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)t -> {
            BigInteger epochNanos = t.getBigInteger();
            return KvdbSerdesUtils$.MODULE$.epochNanosToInstant(package$.MODULE$.BigInt().apply(epochNanos));
        }, Typeable$.MODULE$.namedSimpleTypeable(Instant.class, (Function0 & Serializable)() -> "Instant"));
        bitmap$init$0 |= 0x1000;
        uuidFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$9 -> x$9.getUUID(), Typeable$.MODULE$.namedSimpleTypeable(UUID.class, (Function0 & Serializable)() -> "UUID"));
        bitmap$init$0 |= 0x2000;
        versionstampFdbKeyDecoder = MODULE$.createTry((Function1 & Serializable)x$10 -> x$10.getVersionStamp(), Typeable$.MODULE$.namedSimpleTypeable(Versionstamp.class, (Function0 & Serializable)() -> "Versionstamp"));
        bitmap$init$0 |= 0x4000;
    }

    public <T> FdbKeyDeserializer<T> createTry(Function1<FdbTupleReader, T> f, Typeable<T> typ) {
        return in -> {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(f.apply((Object)in));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                Left left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n                |Failed decoding to ").append(typ.describe()).append(": ").append(e.toString()).append("\n                |------------------------------------------------\n                |Details: ").append(in.toString()).append("\n                |------------------------------------------------\n                |").toString())), e));
                right = left;
            }
            return right;
        };
    }

    public FdbKeyDeserializer<String> stringFdbKeyDecoder() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 51");
        }
        return stringFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> intFdbKeyDecoder() {
        if ((bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 52");
        }
        return intFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> longFdbKeyDecoder() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 53");
        }
        return longFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> byteFdbKeyDecoder() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 54");
        }
        return byteFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> shortFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 55");
        }
        return shortFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> doubleFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 56");
        }
        return doubleFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> floatFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 57");
        }
        return floatFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Object> booleanFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 58");
        }
        return booleanFdbKeyDecoder;
    }

    public FdbKeyDeserializer<ArraySeq<Object>> byteArraySeqFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 60");
        }
        return byteArraySeqFdbKeyDecoder;
    }

    public FdbKeyDeserializer<LocalDate> ldFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 62");
        }
        return ldFdbKeyDecoder;
    }

    public FdbKeyDeserializer<LocalTime> ltFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 66");
        }
        return ltFdbKeyDecoder;
    }

    public FdbKeyDeserializer<YearMonth> ymFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 70");
        }
        return ymFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Instant> instantFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x1000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 81");
        }
        return instantFdbKeyDecoder;
    }

    public FdbKeyDeserializer<UUID> uuidFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x2000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 86");
        }
        return uuidFdbKeyDecoder;
    }

    public FdbKeyDeserializer<Versionstamp> versionstampFdbKeyDecoder() {
        if ((bitmap$init$0 & 0x4000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /runner/_work/chopsticks/chopsticks/chopsticks-kvdb-codec-fdb-key/src/main/scala/dev/chopsticks/kvdb/codec/FdbKeyDeserializer.scala: 87");
        }
        return versionstampFdbKeyDecoder;
    }

    public <T extends GeneratedEnum> FdbKeyDeserializer<T> protobufEnumFdbKeyDecoder(FdbKeyDeserializer<Object> underlyingDecoder, GeneratedEnumCompanion<T> comp, Typeable<T> typ) {
        return in -> underlyingDecoder.deserialize(in).flatMap((Function1 & Serializable)u -> FdbKeyDeserializer$.$anonfun$protobufEnumFdbKeyDecoder$2(comp, typ, BoxesRunTime.unboxToInt((Object)u)));
    }

    public <E extends ByteEnumEntry> FdbKeyDeserializer<E> enumeratumByteEnumKeyDecoder(ByteEnum<E> e) {
        return in -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ByteEnumEntry)e.withValue((Object)BoxesRunTime.boxToByte((byte)in.getBigInteger().byteValueExact())));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(e.getMessage(), e));
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                ByteEnumEntry value = (ByteEnumEntry)success.value();
                left = package$.MODULE$.Right().apply((Object)value);
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        };
    }

    public <E extends ShortEnumEntry> FdbKeyDeserializer<E> enumeratumShortEnumKeyDecoder(ShortEnum<E> e) {
        return in -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ShortEnumEntry)e.withValue((Object)BoxesRunTime.boxToShort((short)in.getBigInteger().shortValueExact())));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(e.getMessage(), e));
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                ShortEnumEntry value = (ShortEnumEntry)success.value();
                left = package$.MODULE$.Right().apply((Object)value);
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        };
    }

    public <E extends IntEnumEntry> FdbKeyDeserializer<E> enumeratumIntEnumKeyDecoder(IntEnum<E> e) {
        return in -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (IntEnumEntry)e.withValue((Object)BoxesRunTime.boxToInteger((int)in.getBigInteger().intValueExact())));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(e.getMessage(), e));
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                IntEnumEntry value = (IntEnumEntry)success.value();
                left = package$.MODULE$.Right().apply((Object)value);
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        };
    }

    public <E extends EnumEntry> FdbKeyDeserializer<E> enumeratumEnumKeyDecoder(Enum<E> e) {
        return in -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> e.withName(in.getString()));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(e.getMessage(), e));
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                EnumEntry value = (EnumEntry)success.value();
                left = package$.MODULE$.Right().apply((Object)value);
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        };
    }

    public <F, T, P> FdbKeyDeserializer<F> refinedFdbKeyDeserializer(FdbKeyDeserializer<T> deserializer, RefType<F> refType, Validate<T, P> validate) {
        return in -> deserializer.deserialize(in).flatMap((Function1 & Serializable)value -> EitherOps$.MODULE$.leftMap$extension(package.either$.MODULE$.catsSyntaxEither(refType.refine().apply(value, validate)), (Function1 & Serializable)x$11 -> new KeyDeserializer.GenericKeyDeserializationException(x$11, KeyDeserializer.GenericKeyDeserializationException$.MODULE$.apply$default$2())));
    }

    public <T> FdbKeyDeserializer<Option<T>> optionFdbKeyDecoder(FdbKeyDeserializer<T> decoder) {
        return in -> MODULE$.booleanFdbKeyDecoder().deserialize(in).flatMap((Function1 & Serializable)nonEmpty -> FdbKeyDeserializer$.$anonfun$optionFdbKeyDecoder$2(decoder, in, BoxesRunTime.unboxToBoolean((Object)nonEmpty)));
    }

    public <A> FdbKeyDeserializer<A> combine(CaseClass<FdbKeyDeserializer, A> ctx) {
        return in -> (Either)ctx.constructMonadic((Function1 & Serializable)param -> ((FdbKeyDeserializer)param.typeclass()).deserialize(in), new Monadic<?>(){

            public <A> Either<KeyDeserializer.DecodingFailure, A> point(A value) {
                return new Right(value);
            }

            public <A, B> Either<KeyDeserializer.DecodingFailure, B> flatMap(Either<KeyDeserializer.DecodingFailure, A> from, Function1<A, Either<KeyDeserializer.DecodingFailure, B>> fn) {
                return from.flatMap(fn);
            }

            public <A, B> Either<KeyDeserializer.DecodingFailure, B> map(Either<KeyDeserializer.DecodingFailure, A> from, Function1<A, B> fn) {
                return from.map(fn);
            }
        });
    }

    public <A, Tag> FdbKeyDeserializer<A> dispatch(SealedTrait<FdbKeyDeserializer, A> ctx, FdbKeyCoproductTag<A> tag, FdbKeyDeserializer<Tag> tagDeserializer) {
        return in -> tagDeserializer.deserialize(in).flatMap((Function1 & Serializable)tagFromTuple -> {
            Left left;
            Option option = tag.tagToSubType(ctx.subtypes(), tagFromTuple);
            if (option instanceof Some) {
                Some some = (Some)option;
                Subtype subType = (Subtype)some.value();
                left = ((FdbKeyDeserializer)subType.typeclass()).deserialize(in);
            } else if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(new StringBuilder(39).append("Cannot determine subType for ").append(ctx.typeName()).append(" from tag ").append(tagFromTuple).toString(), KeyDeserializer.GenericKeyDeserializationException$.MODULE$.apply$default$2()));
            } else {
                throw new MatchError(option);
            }
            return left.map((Function1 & Serializable)result -> result);
        });
    }

    public static final /* synthetic */ int $anonfun$intFdbKeyDecoder$1(FdbTupleReader x$2) {
        return x$2.getBigInteger().intValueExact();
    }

    public static final /* synthetic */ long $anonfun$longFdbKeyDecoder$1(FdbTupleReader x$3) {
        return x$3.getBigInteger().longValueExact();
    }

    public static final /* synthetic */ byte $anonfun$byteFdbKeyDecoder$1(FdbTupleReader x$4) {
        return x$4.getBigInteger().byteValueExact();
    }

    public static final /* synthetic */ short $anonfun$shortFdbKeyDecoder$1(FdbTupleReader x$5) {
        return x$5.getBigInteger().shortValueExact();
    }

    public static final /* synthetic */ Either $anonfun$protobufEnumFdbKeyDecoder$2(GeneratedEnumCompanion comp$1, Typeable typ$2, int u) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)comp$1.fromValue(u));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Left left = package$.MODULE$.Left().apply((Object)new KeyDeserializer.GenericKeyDeserializationException(new StringBuilder(32).append("Failed decoding to proto enum ").append(typ$2.describe()).append(": ").append(e.toString()).toString(), e));
            right = left;
        }
        return right;
    }

    public static final /* synthetic */ Either $anonfun$optionFdbKeyDecoder$2(FdbKeyDeserializer decoder$1, FdbTupleReader in$5, boolean nonEmpty) {
        return (nonEmpty ? decoder$1.deserialize(in$5).map((Function1 & Serializable)v -> new Some(v)) : package$.MODULE$.Right().apply((Object)None$.MODULE$)).map((Function1 & Serializable)ret -> ret);
    }

    private FdbKeyDeserializer$() {
    }
}

