(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-dice-tray'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-dice-tray'.");
    }root['kotlin-dice-tray'] = factory(typeof this['kotlin-dice-tray'] === 'undefined' ? {} : this['kotlin-dice-tray'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Random = Kotlin.kotlin.random.Random;
  var random = Kotlin.kotlin.ranges.random_xmiyix$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  function Die(lowerBound, upperBound, modifiers) {
    Die$Companion_getInstance();
    if (modifiers === void 0)
      modifiers = emptyList();
    this.lowerBound_7ybai4$_0 = lowerBound;
    this.upperBound_1lutbp$_0 = upperBound;
    this.modifiers_rsuh95$_0 = modifiers;
    if (this.lowerBound > this.upperBound) {
      throw IllegalArgumentException_init('The value of lowerBound must be smaller than the value of upperBound.' + (' lowerBound: ' + this.lowerBound + ', upperBound: ' + this.upperBound));
    }}
  Object.defineProperty(Die.prototype, 'lowerBound', {
    get: function () {
      return this.lowerBound_7ybai4$_0;
    }
  });
  Object.defineProperty(Die.prototype, 'upperBound', {
    get: function () {
      return this.upperBound_1lutbp$_0;
    }
  });
  Object.defineProperty(Die.prototype, 'modifiers', {
    get: function () {
      return this.modifiers_rsuh95$_0;
    }
  });
  function Die$Companion() {
    Die$Companion_instance = this;
  }
  Die$Companion.prototype.d4_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 4, modifiers);
  };
  Die$Companion.prototype.d6_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 6, modifiers);
  };
  Die$Companion.prototype.d8_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 8, modifiers);
  };
  Die$Companion.prototype.d10_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 10, modifiers);
  };
  Die$Companion.prototype.d12_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 12, modifiers);
  };
  Die$Companion.prototype.d20_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 20, modifiers);
  };
  Die$Companion.prototype.d100_17cob2$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 100, modifiers);
  };
  Die$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Die$Companion_instance = null;
  function Die$Companion_getInstance() {
    if (Die$Companion_instance === null) {
      new Die$Companion();
    }return Die$Companion_instance;
  }
  Die.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Die',
    interfaces: [DieInterface]
  };
  function DieInterface() {
  }
  DieInterface.prototype.roll = function () {
    var roll = random(new IntRange(this.lowerBound, this.upperBound), Random.Default);
    var tmp$;
    var sum = 0;
    tmp$ = this.modifiers.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sum = sum + element.value | 0;
    }
    return new RollResult(roll + sum | 0, this.modifiers, roll);
  };
  DieInterface.prototype.rollMultiple_za3lpa$ = function (numberOfRolls) {
    if (numberOfRolls >= 2) {
      var $receiver = new IntRange(1, numberOfRolls);
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(this.roll());
      }
      return destination;
    } else {
      throw IllegalArgumentException_init('Must request at least two rolls.');
    }
  };
  DieInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DieInterface',
    interfaces: []
  };
  function RollModifier(value, reason) {
    if (reason === void 0)
      reason = null;
    this.value = value;
    this.reason = reason;
  }
  RollModifier.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RollModifier',
    interfaces: []
  };
  RollModifier.prototype.component1 = function () {
    return this.value;
  };
  RollModifier.prototype.component2 = function () {
    return this.reason;
  };
  RollModifier.prototype.copy_vqvrqt$ = function (value, reason) {
    return new RollModifier(value === void 0 ? this.value : value, reason === void 0 ? this.reason : reason);
  };
  RollModifier.prototype.toString = function () {
    return 'RollModifier(value=' + Kotlin.toString(this.value) + (', reason=' + Kotlin.toString(this.reason)) + ')';
  };
  RollModifier.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.reason) | 0;
    return result;
  };
  RollModifier.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.value, other.value) && Kotlin.equals(this.reason, other.reason)))));
  };
  function RollResult(value, modifiers, rawValue) {
    this.value = value;
    this.modifiers = modifiers;
    this.rawValue = rawValue;
  }
  RollResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RollResult',
    interfaces: []
  };
  RollResult.prototype.component1 = function () {
    return this.value;
  };
  RollResult.prototype.component2 = function () {
    return this.modifiers;
  };
  RollResult.prototype.component3 = function () {
    return this.rawValue;
  };
  RollResult.prototype.copy_mvqmfm$ = function (value, modifiers, rawValue) {
    return new RollResult(value === void 0 ? this.value : value, modifiers === void 0 ? this.modifiers : modifiers, rawValue === void 0 ? this.rawValue : rawValue);
  };
  RollResult.prototype.toString = function () {
    return 'RollResult(value=' + Kotlin.toString(this.value) + (', modifiers=' + Kotlin.toString(this.modifiers)) + (', rawValue=' + Kotlin.toString(this.rawValue)) + ')';
  };
  RollResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.modifiers) | 0;
    result = result * 31 + Kotlin.hashCode(this.rawValue) | 0;
    return result;
  };
  RollResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.value, other.value) && Kotlin.equals(this.modifiers, other.modifiers) && Kotlin.equals(this.rawValue, other.rawValue)))));
  };
  Object.defineProperty(Die, 'Companion', {
    get: Die$Companion_getInstance
  });
  var package$dev = _.dev || (_.dev = {});
  var package$chauvin = package$dev.chauvin || (package$dev.chauvin = {});
  var package$dicetray = package$chauvin.dicetray || (package$chauvin.dicetray = {});
  var package$dice = package$dicetray.dice || (package$dicetray.dice = {});
  package$dice.Die = Die;
  package$dice.DieInterface = DieInterface;
  var package$roll = package$dicetray.roll || (package$dicetray.roll = {});
  package$roll.RollModifier = RollModifier;
  package$roll.RollResult = RollResult;
  Die.prototype.roll = DieInterface.prototype.roll;
  Die.prototype.rollMultiple_za3lpa$ = DieInterface.prototype.rollMultiple_za3lpa$;
  Kotlin.defineModule('kotlin-dice-tray', _);
  return _;
}));

//# sourceMappingURL=kotlin-dice-tray.js.map
