(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-dice-tray'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-dice-tray'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'kotlin-dice-tray'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'kotlin-dice-tray'.");
    }root['kotlin-dice-tray'] = factory(typeof this['kotlin-dice-tray'] === 'undefined' ? {} : this['kotlin-dice-tray'], kotlin, this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$kotlinx_coroutines_core) {
  'use strict';
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var flowOf = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.flowOf_mh5how$;
  var asFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.asFlow_7wnvza$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Random = Kotlin.kotlin.random.Random;
  var random = Kotlin.kotlin.ranges.random_xmiyix$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  function Die(lowerBound, upperBound, modifiers) {
    Die$Companion_getInstance();
    if (modifiers === void 0)
      modifiers = emptyList();
    this.lowerBound_9p0rg8$_0 = lowerBound;
    this.upperBound_4unmf$_0 = upperBound;
    this.modifiers_ddwlo3$_0 = modifiers;
    if (this.lowerBound > this.upperBound) {
      throw IllegalArgumentException_init('The value of lowerBound must be smaller than the value of upperBound.' + (' lowerBound: ' + this.lowerBound + ', upperBound: ' + this.upperBound));
    }}
  Object.defineProperty(Die.prototype, 'lowerBound', {
    get: function () {
      return this.lowerBound_9p0rg8$_0;
    }
  });
  Object.defineProperty(Die.prototype, 'upperBound', {
    get: function () {
      return this.upperBound_4unmf$_0;
    }
  });
  Object.defineProperty(Die.prototype, 'modifiers', {
    get: function () {
      return this.modifiers_ddwlo3$_0;
    }
  });
  function Die$Companion() {
    Die$Companion_instance = this;
  }
  Die$Companion.prototype.d4_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 4, modifiers);
  };
  Die$Companion.prototype.d6_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 6, modifiers);
  };
  Die$Companion.prototype.d8_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 8, modifiers);
  };
  Die$Companion.prototype.d10_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 10, modifiers);
  };
  Die$Companion.prototype.d12_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 12, modifiers);
  };
  Die$Companion.prototype.d20_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 20, modifiers);
  };
  Die$Companion.prototype.d100_ujj84s$ = function (modifiers) {
    if (modifiers === void 0)
      modifiers = emptyList();
    return new Die(1, 100, modifiers);
  };
  Die$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Die$Companion_instance = null;
  function Die$Companion_getInstance() {
    if (Die$Companion_instance === null) {
      new Die$Companion();
    }return Die$Companion_instance;
  }
  Die.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Die',
    interfaces: [DieInterface]
  };
  function DieInterface() {
  }
  DieInterface.prototype.roll = function () {
    var roll = random(new IntRange(this.lowerBound, this.upperBound), Random.Default);
    var tmp$ = this.modifiers;
    var tmp$_0;
    var sum = 0;
    tmp$_0 = this.modifiers.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      sum = sum + element.value | 0;
    }
    return new RollResult(roll, tmp$, roll + sum | 0);
  };
  DieInterface.prototype.suspendableRoll = function (continuation) {
    return flowOf(this.roll());
  };
  DieInterface.prototype.rollMultiple_za3lpa$ = function (numberOfRolls) {
    if (numberOfRolls >= 2) {
      var $receiver = new IntRange(1, numberOfRolls);
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(this.roll());
      }
      return destination;
    } else {
      throw IllegalArgumentException_init('Must request at least two rolls.');
    }
  };
  DieInterface.prototype.suspendableRollMultiple_za3lpa$ = function (numberOfRolls, continuation) {
    if (numberOfRolls >= 2) {
      var $receiver = new IntRange(1, numberOfRolls);
      var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        var tmp$_0 = destination.add_11rb$;
        var roll = random(new IntRange(this.lowerBound, this.upperBound), Random.Default);
        var tmp$_1 = this.modifiers;
        var tmp$_2;
        var sum = 0;
        tmp$_2 = this.modifiers.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          sum = sum + element.value | 0;
        }
        tmp$_0.call(destination, new RollResult(roll, tmp$_1, roll + sum | 0));
      }
      return asFlow(destination);
    } else {
      throw IllegalArgumentException_init('Must request at least two rolls.');
    }
  };
  DieInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DieInterface',
    interfaces: []
  };
  function RollModifier(value, reason) {
    if (reason === void 0)
      reason = null;
    this.value = value;
    this.reason = reason;
  }
  RollModifier.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RollModifier',
    interfaces: []
  };
  RollModifier.prototype.component1 = function () {
    return this.value;
  };
  RollModifier.prototype.component2 = function () {
    return this.reason;
  };
  RollModifier.prototype.copy_vqvrqt$ = function (value, reason) {
    return new RollModifier(value === void 0 ? this.value : value, reason === void 0 ? this.reason : reason);
  };
  RollModifier.prototype.toString = function () {
    return 'RollModifier(value=' + Kotlin.toString(this.value) + (', reason=' + Kotlin.toString(this.reason)) + ')';
  };
  RollModifier.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.reason) | 0;
    return result;
  };
  RollModifier.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.value, other.value) && Kotlin.equals(this.reason, other.reason)))));
  };
  function RollResult(value, modifiers, modifiedValue) {
    this.value = value;
    this.modifiers = modifiers;
    this.modifiedValue = modifiedValue;
  }
  RollResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RollResult',
    interfaces: []
  };
  RollResult.prototype.component1 = function () {
    return this.value;
  };
  RollResult.prototype.component2 = function () {
    return this.modifiers;
  };
  RollResult.prototype.component3 = function () {
    return this.modifiedValue;
  };
  RollResult.prototype.copy_du4vv8$ = function (value, modifiers, modifiedValue) {
    return new RollResult(value === void 0 ? this.value : value, modifiers === void 0 ? this.modifiers : modifiers, modifiedValue === void 0 ? this.modifiedValue : modifiedValue);
  };
  RollResult.prototype.toString = function () {
    return 'RollResult(value=' + Kotlin.toString(this.value) + (', modifiers=' + Kotlin.toString(this.modifiers)) + (', modifiedValue=' + Kotlin.toString(this.modifiedValue)) + ')';
  };
  RollResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.modifiers) | 0;
    result = result * 31 + Kotlin.hashCode(this.modifiedValue) | 0;
    return result;
  };
  RollResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.value, other.value) && Kotlin.equals(this.modifiers, other.modifiers) && Kotlin.equals(this.modifiedValue, other.modifiedValue)))));
  };
  Object.defineProperty(Die, 'Companion', {
    get: Die$Companion_getInstance
  });
  var package$dice = _.dice || (_.dice = {});
  package$dice.Die = Die;
  package$dice.DieInterface = DieInterface;
  var package$roll = _.roll || (_.roll = {});
  package$roll.RollModifier = RollModifier;
  package$roll.RollResult = RollResult;
  Die.prototype.roll = DieInterface.prototype.roll;
  Die.prototype.suspendableRoll = DieInterface.prototype.suspendableRoll;
  Die.prototype.rollMultiple_za3lpa$ = DieInterface.prototype.rollMultiple_za3lpa$;
  Die.prototype.suspendableRollMultiple_za3lpa$ = DieInterface.prototype.suspendableRollMultiple_za3lpa$;
  Kotlin.defineModule('kotlin-dice-tray', _);
  return _;
}));

//# sourceMappingURL=kotlin-dice-tray.js.map
