/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.request.Request;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.api.v1.svc.CerbosServiceGrpc;
import dev.cerbos.sdk.CerbosException;
import dev.cerbos.sdk.CheckResourcesRequestBuilder;
import dev.cerbos.sdk.CheckResult;
import dev.cerbos.sdk.PlanResourcesResult;
import dev.cerbos.sdk.PlaygroundInstanceCredentials;
import dev.cerbos.sdk.RequestId;
import dev.cerbos.sdk.builders.AuxData;
import dev.cerbos.sdk.builders.Principal;
import dev.cerbos.sdk.builders.Resource;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CerbosBlockingClient {
    private final CerbosServiceGrpc.CerbosServiceBlockingStub cerbosStub;
    private final long timeoutMillis;
    private final Optional<AuxData> auxData;

    CerbosBlockingClient(Channel channel, long timeoutMillis, PlaygroundInstanceCredentials playgroundCredentials) {
        CerbosServiceGrpc.CerbosServiceBlockingStub c = CerbosServiceGrpc.newBlockingStub(channel);
        this.cerbosStub = playgroundCredentials != null ? (CerbosServiceGrpc.CerbosServiceBlockingStub)c.withCallCredentials(playgroundCredentials) : c;
        this.timeoutMillis = timeoutMillis;
        this.auxData = Optional.empty();
    }

    CerbosBlockingClient(CerbosServiceGrpc.CerbosServiceBlockingStub cerbosStub, long timeoutMillis, AuxData auxData) {
        this.cerbosStub = cerbosStub;
        this.timeoutMillis = timeoutMillis;
        this.auxData = Optional.ofNullable(auxData);
    }

    private CerbosServiceGrpc.CerbosServiceBlockingStub withClient() {
        return (CerbosServiceGrpc.CerbosServiceBlockingStub)this.cerbosStub.withDeadlineAfter(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public CerbosBlockingClient with(AuxData auxData) {
        return new CerbosBlockingClient(this.cerbosStub, this.timeoutMillis, auxData);
    }

    public CheckResult check(Principal principal, Resource resource, String ... actions) {
        Request.AuxData ad = this.auxData.map(AuxData::toAuxData).orElseGet(Request.AuxData::getDefaultInstance);
        Request.CheckResourcesRequest request = Request.CheckResourcesRequest.newBuilder().setRequestId(RequestId.generate()).setPrincipal(principal.toPrincipal()).setAuxData(ad).addResources(Request.CheckResourcesRequest.ResourceEntry.newBuilder().setResource(resource.toResource()).addAllActions(Arrays.asList(actions)).build()).build();
        try {
            Response.CheckResourcesResponse response = this.withClient().checkResources(request);
            if (response.getResultsCount() == 1) {
                return new CheckResult(response.getResults(0));
            }
            return new CheckResult(null);
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public CheckResourcesRequestBuilder batch(Principal principal) {
        return new CheckResourcesRequestBuilder(this::withClient, this.auxData.map(AuxData::toAuxData).orElseGet(Request.AuxData::getDefaultInstance), principal.toPrincipal());
    }

    public CheckResourcesRequestBuilder batch(Principal principal, AuxData auxData) {
        return new CheckResourcesRequestBuilder(this::withClient, auxData.toAuxData(), principal.toPrincipal());
    }

    public PlanResourcesResult plan(Principal principal, Resource resource, String action) {
        Request.AuxData ad = this.auxData.map(AuxData::toAuxData).orElseGet(Request.AuxData::getDefaultInstance);
        Request.PlanResourcesRequest request = Request.PlanResourcesRequest.newBuilder().setRequestId(RequestId.generate()).setPrincipal(principal.toPrincipal()).setResource(resource.toPlanResource()).setAuxData(ad).setAction(action).build();
        try {
            Response.PlanResourcesResponse response = this.withClient().planResources(request);
            return new PlanResourcesResult(response);
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }
}

