/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.engine.Engine;
import dev.cerbos.api.v1.request.Request;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.api.v1.svc.CerbosServiceGrpc;
import dev.cerbos.sdk.CerbosException;
import dev.cerbos.sdk.CheckResourcesResult;
import dev.cerbos.sdk.RequestId;
import dev.cerbos.sdk.builders.Resource;
import dev.cerbos.sdk.builders.ResourceAction;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CheckResourcesRequestBuilder {
    private final Supplier<CerbosServiceGrpc.CerbosServiceBlockingStub> clientStub;
    private final Request.CheckResourcesRequest.Builder requestBuilder;

    CheckResourcesRequestBuilder(Supplier<CerbosServiceGrpc.CerbosServiceBlockingStub> clientStub, Request.AuxData auxData, Engine.Principal principal) {
        this.clientStub = clientStub;
        this.requestBuilder = Request.CheckResourcesRequest.newBuilder().setRequestId(RequestId.generate()).setPrincipal(principal).setAuxData(auxData);
    }

    public CheckResourcesRequestBuilder addResourceAndActions(Resource resource, String ... actions) {
        this.requestBuilder.addResources(Request.CheckResourcesRequest.ResourceEntry.newBuilder().setResource(resource.toResource()).addAllActions(Arrays.asList(actions)).build());
        return this;
    }

    public CheckResourcesRequestBuilder addResources(ResourceAction ... resources) {
        this.requestBuilder.addAllResources(Arrays.stream(resources).map(ResourceAction::toResourceEntry).collect(Collectors.toList()));
        return this;
    }

    public CheckResourcesResult check() {
        try {
            Response.CheckResourcesResponse resp = this.clientStub.get().checkResources(this.requestBuilder.build());
            return new CheckResourcesResult(resp);
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }
}

