/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.effect.EffectOuterClass;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.sdk.CheckResult;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CheckResourceSetResult {
    private final Response.CheckResourceSetResponse resp;

    CheckResourceSetResult(Response.CheckResourceSetResponse resp) {
        this.resp = resp;
    }

    public boolean isAllowed(String resourceId, String action) {
        if (this.resp.containsResourceInstances(resourceId)) {
            Response.CheckResourceSetResponse.ActionEffectMap resource = this.resp.getResourceInstancesOrThrow(resourceId);
            return resource.getActionsOrDefault(action, EffectOuterClass.Effect.EFFECT_DENY) == EffectOuterClass.Effect.EFFECT_ALLOW;
        }
        return false;
    }

    public Optional<CheckResult> get(String resourceId) {
        if (this.resp.containsResourceInstances(resourceId)) {
            Response.CheckResourceSetResponse.ActionEffectMap resource = this.resp.getResourceInstancesOrThrow(resourceId);
            return Optional.of(new CheckResult(resource.getActionsMap()));
        }
        return Optional.empty();
    }

    public Map<String, CheckResult> getAll() {
        return this.resp.getResourceInstancesMap().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> new CheckResult(((Response.CheckResourceSetResponse.ActionEffectMap)e.getValue()).getActionsMap())));
    }

    public Response.CheckResourceSetResponse getRaw() {
        return this.resp;
    }
}

