/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.response.Response;
import dev.cerbos.sdk.CheckResult;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CheckResourceBatchResult {
    private final Response.CheckResourceBatchResponse resp;
    private volatile Map<String, CheckResult> resultMap;

    CheckResourceBatchResult(Response.CheckResourceBatchResponse resp) {
        this.resp = resp;
    }

    private Map<String, CheckResult> toResultMap() {
        return this.resp.getResultsList().stream().collect(Collectors.toUnmodifiableMap(Response.CheckResourceBatchResponse.ActionEffectMap::getResourceId, e -> new CheckResult(e.getActionsMap())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CheckResult> getAll() {
        if (this.resultMap == null) {
            CheckResourceBatchResult checkResourceBatchResult = this;
            synchronized (checkResourceBatchResult) {
                if (this.resultMap == null) {
                    this.resultMap = this.toResultMap();
                }
            }
        }
        return this.resultMap;
    }

    public Optional<CheckResult> get(String resourceId) {
        Map<String, CheckResult> m = this.getAll();
        return Optional.ofNullable(m.get(resourceId));
    }

    public boolean isAllowed(String resourceId, String action) {
        Map<String, CheckResult> m = this.getAll();
        if (m.containsKey(resourceId)) {
            return m.get(resourceId).isAllowed(action);
        }
        return false;
    }

    public Response.CheckResourceBatchResponse getRaw() {
        return this.resp;
    }
}

