/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import com.google.protobuf.Value;
import dev.cerbos.api.v1.engine.Engine;
import dev.cerbos.api.v1.request.Request;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.api.v1.svc.CerbosServiceGrpc;
import dev.cerbos.sdk.CerbosException;
import dev.cerbos.sdk.CheckResourceBatchResult;
import dev.cerbos.sdk.CheckResourceSetResult;
import dev.cerbos.sdk.RequestId;
import dev.cerbos.sdk.builders.AttributeValue;
import dev.cerbos.sdk.builders.Resource;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CheckRequestBuilder {
    private final Supplier<CerbosServiceGrpc.CerbosServiceBlockingStub> clientStub;
    private final Engine.Principal principal;
    private final Request.AuxData auxData;

    CheckRequestBuilder(Supplier<CerbosServiceGrpc.CerbosServiceBlockingStub> clientStub, Request.AuxData auxData, Engine.Principal principal) {
        this.clientStub = clientStub;
        this.principal = principal;
        this.auxData = auxData;
    }

    public CheckResourceBatchRequestBuilder withResourceAndActions(Resource resource, String ... actions) {
        return new CheckResourceBatchRequestBuilder(resource, actions);
    }

    public CheckResourceSetRequestBuilder withResourceKind(String kind) {
        return new CheckResourceSetRequestBuilder(kind);
    }

    public CheckResourceSetRequestBuilder withResourceKind(String kind, String policyVersion) {
        return new CheckResourceSetRequestBuilder(kind, policyVersion);
    }

    public class CheckResourceBatchRequestBuilder {
        private final Request.CheckResourceBatchRequest.Builder requestBuilder;

        CheckResourceBatchRequestBuilder(Resource resource, String[] actions) {
            this.requestBuilder = Request.CheckResourceBatchRequest.newBuilder().setRequestId(RequestId.generate()).setPrincipal(CheckRequestBuilder.this.principal).setAuxData(CheckRequestBuilder.this.auxData).addResources(Request.CheckResourceBatchRequest.BatchEntry.newBuilder().setResource(resource.toResource()).addAllActions(Arrays.asList(actions)));
        }

        public CheckResourceBatchRequestBuilder withResourceAndActions(Resource resource, String ... actions) {
            this.requestBuilder.addResources(Request.CheckResourceBatchRequest.BatchEntry.newBuilder().setResource(resource.toResource()).addAllActions(Arrays.asList(actions)).build());
            return this;
        }

        public CheckResourceBatchResult check() {
            try {
                Response.CheckResourceBatchResponse resp = CheckRequestBuilder.this.clientStub.get().checkResourceBatch(this.requestBuilder.build());
                return new CheckResourceBatchResult(resp);
            }
            catch (StatusRuntimeException sre) {
                throw new CerbosException(sre.getStatus(), sre.getCause());
            }
        }
    }

    public class CheckResourceSetRequestBuilder {
        private final Request.CheckResourceSetRequest.Builder requestBuilder;
        private final Request.ResourceSet.Builder resourceSetBuilder;

        CheckResourceSetRequestBuilder(String kind) {
            this.requestBuilder = Request.CheckResourceSetRequest.newBuilder().setRequestId(RequestId.generate()).setPrincipal(CheckRequestBuilder.this.principal).setAuxData(CheckRequestBuilder.this.auxData);
            this.resourceSetBuilder = Request.ResourceSet.newBuilder().setKind(kind);
        }

        CheckResourceSetRequestBuilder(String kind, String policyVersion) {
            this.requestBuilder = Request.CheckResourceSetRequest.newBuilder().setRequestId(RequestId.generate()).setPrincipal(CheckRequestBuilder.this.principal).setAuxData(CheckRequestBuilder.this.auxData);
            this.resourceSetBuilder = Request.ResourceSet.newBuilder().setKind(kind).setPolicyVersion(policyVersion);
        }

        public CheckResourceSetRequestBuilder withActions(String ... actions) {
            this.requestBuilder.addAllActions(Arrays.asList(actions));
            return this;
        }

        public CheckResourceSetRequestBuilder withResource(String id, Map<String, AttributeValue> attributes) {
            if (attributes == null) {
                this.resourceSetBuilder.putInstances(id, Request.AttributesMap.newBuilder().build());
            } else {
                Map<String, Value> attrMap = attributes.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((AttributeValue)e.getValue()).toValue()));
                this.resourceSetBuilder.putInstances(id, Request.AttributesMap.newBuilder().putAllAttr(attrMap).build());
            }
            return this;
        }

        public CheckResourceSetResult check() {
            Request.CheckResourceSetRequest request = this.requestBuilder.setResource(this.resourceSetBuilder.build()).build();
            try {
                Response.CheckResourceSetResponse resp = CheckRequestBuilder.this.clientStub.get().checkResourceSet(request);
                return new CheckResourceSetResult(resp);
            }
            catch (StatusRuntimeException sre) {
                throw new CerbosException(sre.getStatus(), sre.getCause());
            }
        }
    }
}

