/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.policy.PolicyOuterClass;
import dev.cerbos.api.v1.request.Request;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.api.v1.schema.SchemaOuterClass;
import dev.cerbos.api.v1.svc.CerbosAdminServiceGrpc;
import dev.cerbos.sdk.AddOrUpdatePolicyRequestBuilder;
import dev.cerbos.sdk.AddOrUpdateSchemaRequestBuilder;
import dev.cerbos.sdk.AdminApiCredentials;
import dev.cerbos.sdk.CerbosException;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.MetadataUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CerbosBlockingAdminClient {
    private final CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub stub;
    private final long timeoutMillis;
    private final Optional<Metadata> headerMetadata;

    CerbosBlockingAdminClient(Channel channel, long timeoutMillis, AdminApiCredentials adminCredentials) {
        CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub c = CerbosAdminServiceGrpc.newBlockingStub(channel);
        this.stub = (CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub)c.withCallCredentials(adminCredentials);
        this.timeoutMillis = timeoutMillis;
        this.headerMetadata = Optional.empty();
    }

    CerbosBlockingAdminClient(CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub stub, long timeoutMillis, Optional<Metadata> headerMetadata) {
        this.stub = stub;
        this.timeoutMillis = timeoutMillis;
        this.headerMetadata = headerMetadata;
    }

    private CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub withClient() {
        CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub s = this.headerMetadata.map(md -> (CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub)this.stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)md)})).orElse(this.stub);
        return (CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub)s.withDeadlineAfter(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public CerbosBlockingAdminClient withHeaders(Metadata md) {
        return new CerbosBlockingAdminClient(this.stub, this.timeoutMillis, Optional.ofNullable(md));
    }

    public CerbosBlockingAdminClient withHeaders(Map<String, String> headers) {
        Metadata md = new Metadata();
        headers.forEach((k, v) -> md.put(Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), v));
        return this.withHeaders(md);
    }

    public AddOrUpdatePolicyRequestBuilder addOrUpdatePolicy() {
        return new AddOrUpdatePolicyRequestBuilder(this::withClient);
    }

    public List<String> listActivePolicies(Optional<String> nameRegex, Optional<String> versionRegex, Optional<String> scopeRegex) {
        return this.doListPolicies(false, nameRegex, versionRegex, scopeRegex);
    }

    public List<String> listAllPolicies(Optional<String> nameRegex, Optional<String> versionRegex, Optional<String> scopeRegex) {
        return this.doListPolicies(true, nameRegex, versionRegex, scopeRegex);
    }

    private List<String> doListPolicies(boolean includeDisabled, Optional<String> nameRegex, Optional<String> versionRegex, Optional<String> scopeRegex) {
        Request.ListPoliciesRequest.Builder requestBuilder = Request.ListPoliciesRequest.newBuilder();
        requestBuilder.setIncludeDisabled(includeDisabled);
        nameRegex.ifPresent(requestBuilder::setNameRegexp);
        versionRegex.ifPresent(requestBuilder::setVersionRegexp);
        scopeRegex.ifPresent(requestBuilder::setScopeRegexp);
        try {
            Response.ListPoliciesResponse resp = this.withClient().listPolicies(requestBuilder.build());
            return resp.getPolicyIdsList().stream().collect(Collectors.toUnmodifiableList());
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public List<PolicyOuterClass.Policy> getPolicy(String ... ids) {
        Request.GetPolicyRequest.Builder requestBuilder = Request.GetPolicyRequest.newBuilder();
        requestBuilder.addAllId(List.of(ids));
        try {
            Response.GetPolicyResponse resp = this.withClient().getPolicy(requestBuilder.build());
            return resp.getPoliciesList();
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public long enablePolicy(String ... ids) {
        Request.EnablePolicyRequest.Builder requestBuilder = Request.EnablePolicyRequest.newBuilder();
        requestBuilder.addAllId(List.of(ids));
        try {
            Response.EnablePolicyResponse resp = this.withClient().enablePolicy(requestBuilder.build());
            return resp.getEnabledPolicies();
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public long disablePolicy(String ... ids) {
        Request.DisablePolicyRequest.Builder requestBuilder = Request.DisablePolicyRequest.newBuilder();
        requestBuilder.addAllId(List.of(ids));
        try {
            Response.DisablePolicyResponse resp = this.withClient().disablePolicy(requestBuilder.build());
            return resp.getDisabledPolicies();
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public AddOrUpdateSchemaRequestBuilder addOrUpdateSchema() {
        return new AddOrUpdateSchemaRequestBuilder(this::withClient);
    }

    public List<String> listSchemas() {
        try {
            Response.ListSchemasResponse resp = this.withClient().listSchemas(Request.ListSchemasRequest.newBuilder().build());
            return resp.getSchemaIdsList().stream().collect(Collectors.toUnmodifiableList());
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public List<SchemaOuterClass.Schema> getSchema(String ... ids) {
        Request.GetSchemaRequest.Builder requestBuilder = Request.GetSchemaRequest.newBuilder();
        requestBuilder.addAllId(List.of(ids));
        try {
            Response.GetSchemaResponse resp = this.withClient().getSchema(requestBuilder.build());
            return resp.getSchemasList();
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public long deleteSchema(String ... ids) {
        Request.DeleteSchemaRequest.Builder requestBuilder = Request.DeleteSchemaRequest.newBuilder();
        requestBuilder.addAllId(List.of(ids));
        try {
            Response.DeleteSchemaResponse resp = this.withClient().deleteSchema(requestBuilder.build());
            return resp.getDeletedSchemas();
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }

    public void storeReload(boolean wait) {
        try {
            this.withClient().reloadStore(Request.ReloadStoreRequest.newBuilder().setWait(wait).build());
        }
        catch (StatusRuntimeException sre) {
            throw new CerbosException(sre.getStatus(), sre.getCause());
        }
    }
}

