/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import com.google.protobuf.ByteString;
import dev.cerbos.api.v1.request.Request;
import dev.cerbos.api.v1.schema.SchemaOuterClass;
import dev.cerbos.api.v1.svc.CerbosAdminServiceGrpc;
import dev.cerbos.sdk.CerbosException;
import io.envoyproxy.pgv.ReflectiveValidatorIndex;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.Validator;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.io.input.ReaderInputStream;

public class AddOrUpdateSchemaRequestBuilder {
    private final Supplier<CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub> clientStub;
    private static final Validator<SchemaOuterClass.Schema> VALIDATOR = new ReflectiveValidatorIndex().validatorFor(SchemaOuterClass.Schema.class);
    private final List<SchemaOuterClass.Schema> schemas = new ArrayList<SchemaOuterClass.Schema>();

    AddOrUpdateSchemaRequestBuilder(Supplier<CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub> clientStub) {
        this.clientStub = clientStub;
    }

    public AddOrUpdateSchemaRequestBuilder with(String id, Reader schemaJson) throws IOException, ValidationException {
        SchemaOuterClass.Schema.Builder schemaBuilder = SchemaOuterClass.Schema.newBuilder();
        SchemaOuterClass.Schema schema = schemaBuilder.setId(id).setDefinition(ByteString.readFrom((InputStream)new ReaderInputStream(schemaJson))).build();
        VALIDATOR.assertValid((Object)schema);
        this.schemas.add(schema);
        return this;
    }

    public AddOrUpdateSchemaRequestBuilder with(String id, String schemaJson) throws IOException, ValidationException {
        return this.with(id, new StringReader(schemaJson));
    }

    public AddOrUpdateSchemaRequestBuilder with(Iterable<SchemaOuterClass.Schema> schemaList) throws ValidationException {
        for (SchemaOuterClass.Schema s : schemaList) {
            VALIDATOR.assertValid((Object)s);
            this.schemas.add(s);
        }
        return this;
    }

    public void addOrUpdate() {
        Request.AddOrUpdateSchemaRequest.Builder batch = Request.AddOrUpdateSchemaRequest.newBuilder();
        int batchSize = 0;
        for (int i = 1; i <= this.schemas.size(); ++i) {
            if (i % 10 == 0) {
                try {
                    this.clientStub.get().addOrUpdateSchema(batch.build());
                }
                catch (StatusRuntimeException sre) {
                    throw new CerbosException(sre.getStatus(), sre.getCause());
                }
                batch = Request.AddOrUpdateSchemaRequest.newBuilder();
                batchSize = 0;
            }
            batch.addSchemas(this.schemas.get(i - 1));
            ++batchSize;
        }
        if (batchSize > 0) {
            try {
                this.clientStub.get().addOrUpdateSchema(batch.build());
            }
            catch (StatusRuntimeException sre) {
                throw new CerbosException(sre.getStatus(), sre.getCause());
            }
        }
    }
}

