/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.api.v1.request;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.util.Timestamps;
import com.google.re2j.Pattern;
import dev.cerbos.api.v1.request.Request;
import io.envoyproxy.pgv.BytesValidation;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.MapValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.TimestampValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import java.util.List;

public class RequestValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Request.PlanResourcesRequest.class)) {
            return new PlanResourcesRequestValidator();
        }
        if (clazz.equals(Request.CheckResourceSetRequest.class)) {
            return new CheckResourceSetRequestValidator();
        }
        if (clazz.equals(Request.ResourceSet.class)) {
            return new ResourceSetValidator();
        }
        if (clazz.equals(Request.AttributesMap.class)) {
            return new AttributesMapValidator();
        }
        if (clazz.equals(Request.CheckResourceBatchRequest.class)) {
            return new CheckResourceBatchRequestValidator();
        }
        if (clazz.equals(Request.CheckResourcesRequest.class)) {
            return new CheckResourcesRequestValidator();
        }
        if (clazz.equals(Request.AuxData.class)) {
            return new AuxDataValidator();
        }
        if (clazz.equals(Request.File.class)) {
            return new FileValidator();
        }
        if (clazz.equals(Request.PlaygroundValidateRequest.class)) {
            return new PlaygroundValidateRequestValidator();
        }
        if (clazz.equals(Request.PlaygroundTestRequest.class)) {
            return new PlaygroundTestRequestValidator();
        }
        if (clazz.equals(Request.PlaygroundEvaluateRequest.class)) {
            return new PlaygroundEvaluateRequestValidator();
        }
        if (clazz.equals(Request.PlaygroundProxyRequest.class)) {
            return new PlaygroundProxyRequestValidator();
        }
        if (clazz.equals(Request.AddOrUpdatePolicyRequest.class)) {
            return new AddOrUpdatePolicyRequestValidator();
        }
        if (clazz.equals(Request.ListAuditLogEntriesRequest.class)) {
            return new ListAuditLogEntriesRequestValidator();
        }
        if (clazz.equals(Request.ServerInfoRequest.class)) {
            return new ServerInfoRequestValidator();
        }
        if (clazz.equals(Request.ListPoliciesRequest.class)) {
            return new ListPoliciesRequestValidator();
        }
        if (clazz.equals(Request.GetPolicyRequest.class)) {
            return new GetPolicyRequestValidator();
        }
        if (clazz.equals(Request.DisablePolicyRequest.class)) {
            return new DisablePolicyRequestValidator();
        }
        if (clazz.equals(Request.EnablePolicyRequest.class)) {
            return new EnablePolicyRequestValidator();
        }
        if (clazz.equals(Request.AddOrUpdateSchemaRequest.class)) {
            return new AddOrUpdateSchemaRequestValidator();
        }
        if (clazz.equals(Request.ListSchemasRequest.class)) {
            return new ListSchemasRequestValidator();
        }
        if (clazz.equals(Request.GetSchemaRequest.class)) {
            return new GetSchemaRequestValidator();
        }
        if (clazz.equals(Request.DeleteSchemaRequest.class)) {
            return new DeleteSchemaRequestValidator();
        }
        if (clazz.equals(Request.ReloadStoreRequest.class)) {
            return new ReloadStoreRequestValidator();
        }
        if (clazz.equals(Request.CheckResourceBatchRequest.BatchEntry.class)) {
            return new CheckResourceBatchRequest_BatchEntryValidator();
        }
        if (clazz.equals(Request.CheckResourcesRequest.ResourceEntry.class)) {
            return new CheckResourcesRequest_ResourceEntryValidator();
        }
        if (clazz.equals(Request.AuxData.JWT.class)) {
            return new AuxData_JWTValidator();
        }
        if (clazz.equals(Request.ListAuditLogEntriesRequest.TimeRange.class)) {
            return new ListAuditLogEntriesRequest_TimeRangeValidator();
        }
        return null;
    }

    public static class ListAuditLogEntriesRequest_TimeRangeValidator
    implements ValidatorImpl<Request.ListAuditLogEntriesRequest.TimeRange> {
        public void assertValid(Request.ListAuditLogEntriesRequest.TimeRange proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasStart()) {
                RequiredValidation.required((String)".cerbos.request.v1.ListAuditLogEntriesRequest.TimeRange.start", (GeneratedMessageV3)proto.getStart());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.ListAuditLogEntriesRequest.TimeRange.start", null);
            }
            if (proto.hasStart()) {
                ComparativeValidation.lessThan((String)".cerbos.request.v1.ListAuditLogEntriesRequest.TimeRange.start", (Object)proto.getStart(), (Object)TimestampValidation.currentTimestamp(), (Comparator)Timestamps.comparator());
            }
            if (proto.hasEnd()) {
                RequiredValidation.required((String)".cerbos.request.v1.ListAuditLogEntriesRequest.TimeRange.end", (GeneratedMessageV3)proto.getEnd());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.ListAuditLogEntriesRequest.TimeRange.end", null);
            }
            if (proto.hasEnd()) {
                ComparativeValidation.lessThan((String)".cerbos.request.v1.ListAuditLogEntriesRequest.TimeRange.end", (Object)proto.getEnd(), (Object)TimestampValidation.currentTimestamp(), (Comparator)Timestamps.comparator());
            }
        }
    }

    public static class AuxData_JWTValidator
    implements ValidatorImpl<Request.AuxData.JWT> {
        public void assertValid(Request.AuxData.JWT proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.request.v1.AuxData.JWT.token", (String)proto.getToken(), (int)1);
        }
    }

    public static class CheckResourcesRequest_ResourceEntryValidator
    implements ValidatorImpl<Request.CheckResourcesRequest.ResourceEntry> {
        public void assertValid(Request.CheckResourcesRequest.ResourceEntry proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.CheckResourcesRequest.ResourceEntry.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.request.v1.CheckResourcesRequest.ResourceEntry.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.request.v1.CheckResourcesRequest.ResourceEntry.actions", (String)item, (int)1));
            if (proto.hasResource()) {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourcesRequest.ResourceEntry.resource", (GeneratedMessageV3)proto.getResource());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourcesRequest.ResourceEntry.resource", null);
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
        }
    }

    public static class CheckResourceBatchRequest_BatchEntryValidator
    implements ValidatorImpl<Request.CheckResourceBatchRequest.BatchEntry> {
        public void assertValid(Request.CheckResourceBatchRequest.BatchEntry proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.CheckResourceBatchRequest.BatchEntry.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.request.v1.CheckResourceBatchRequest.BatchEntry.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.request.v1.CheckResourceBatchRequest.BatchEntry.actions", (String)item, (int)1));
            if (proto.hasResource()) {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceBatchRequest.BatchEntry.resource", (GeneratedMessageV3)proto.getResource());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceBatchRequest.BatchEntry.resource", null);
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
        }
    }

    public static class ReloadStoreRequestValidator
    implements ValidatorImpl<Request.ReloadStoreRequest> {
        public void assertValid(Request.ReloadStoreRequest proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class DeleteSchemaRequestValidator
    implements ValidatorImpl<Request.DeleteSchemaRequest> {
        public void assertValid(Request.DeleteSchemaRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.DeleteSchemaRequest.id", (List)proto.getIdList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.DeleteSchemaRequest.id", (List)proto.getIdList(), (int)25);
            RepeatedValidation.unique((String)".cerbos.request.v1.DeleteSchemaRequest.id", (List)proto.getIdList());
            RepeatedValidation.forEach((List)proto.getIdList(), item -> {
                StringValidation.minLength((String)".cerbos.request.v1.DeleteSchemaRequest.id", (String)item, (int)1);
                StringValidation.maxLength((String)".cerbos.request.v1.DeleteSchemaRequest.id", (String)item, (int)255);
            });
        }
    }

    public static class GetSchemaRequestValidator
    implements ValidatorImpl<Request.GetSchemaRequest> {
        public void assertValid(Request.GetSchemaRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.GetSchemaRequest.id", (List)proto.getIdList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.GetSchemaRequest.id", (List)proto.getIdList(), (int)25);
            RepeatedValidation.unique((String)".cerbos.request.v1.GetSchemaRequest.id", (List)proto.getIdList());
            RepeatedValidation.forEach((List)proto.getIdList(), item -> {
                StringValidation.minLength((String)".cerbos.request.v1.GetSchemaRequest.id", (String)item, (int)1);
                StringValidation.maxLength((String)".cerbos.request.v1.GetSchemaRequest.id", (String)item, (int)255);
            });
        }
    }

    public static class ListSchemasRequestValidator
    implements ValidatorImpl<Request.ListSchemasRequest> {
        public void assertValid(Request.ListSchemasRequest proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class AddOrUpdateSchemaRequestValidator
    implements ValidatorImpl<Request.AddOrUpdateSchemaRequest> {
        public void assertValid(Request.AddOrUpdateSchemaRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.AddOrUpdateSchemaRequest.schemas", proto.getSchemasList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.AddOrUpdateSchemaRequest.schemas", proto.getSchemasList(), (int)10);
            RepeatedValidation.forEach(proto.getSchemasList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class EnablePolicyRequestValidator
    implements ValidatorImpl<Request.EnablePolicyRequest> {
        public void assertValid(Request.EnablePolicyRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.EnablePolicyRequest.id", (List)proto.getIdList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.EnablePolicyRequest.id", (List)proto.getIdList(), (int)25);
            RepeatedValidation.unique((String)".cerbos.request.v1.EnablePolicyRequest.id", (List)proto.getIdList());
            RepeatedValidation.forEach((List)proto.getIdList(), item -> {
                StringValidation.minLength((String)".cerbos.request.v1.EnablePolicyRequest.id", (String)item, (int)1);
                StringValidation.maxLength((String)".cerbos.request.v1.EnablePolicyRequest.id", (String)item, (int)1280);
            });
        }
    }

    public static class DisablePolicyRequestValidator
    implements ValidatorImpl<Request.DisablePolicyRequest> {
        public void assertValid(Request.DisablePolicyRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.DisablePolicyRequest.id", (List)proto.getIdList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.DisablePolicyRequest.id", (List)proto.getIdList(), (int)25);
            RepeatedValidation.unique((String)".cerbos.request.v1.DisablePolicyRequest.id", (List)proto.getIdList());
            RepeatedValidation.forEach((List)proto.getIdList(), item -> {
                StringValidation.minLength((String)".cerbos.request.v1.DisablePolicyRequest.id", (String)item, (int)1);
                StringValidation.maxLength((String)".cerbos.request.v1.DisablePolicyRequest.id", (String)item, (int)1280);
            });
        }
    }

    public static class GetPolicyRequestValidator
    implements ValidatorImpl<Request.GetPolicyRequest> {
        public void assertValid(Request.GetPolicyRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.GetPolicyRequest.id", (List)proto.getIdList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.GetPolicyRequest.id", (List)proto.getIdList(), (int)25);
            RepeatedValidation.unique((String)".cerbos.request.v1.GetPolicyRequest.id", (List)proto.getIdList());
            RepeatedValidation.forEach((List)proto.getIdList(), item -> {
                StringValidation.minLength((String)".cerbos.request.v1.GetPolicyRequest.id", (String)item, (int)1);
                StringValidation.maxLength((String)".cerbos.request.v1.GetPolicyRequest.id", (String)item, (int)1280);
            });
        }
    }

    public static class ListPoliciesRequestValidator
    implements ValidatorImpl<Request.ListPoliciesRequest> {
        public void assertValid(Request.ListPoliciesRequest proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class ServerInfoRequestValidator
    implements ValidatorImpl<Request.ServerInfoRequest> {
        public void assertValid(Request.ServerInfoRequest proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class ListAuditLogEntriesRequestValidator
    implements ValidatorImpl<Request.ListAuditLogEntriesRequest> {
        private final Request.ListAuditLogEntriesRequest.Kind[] KIND__IN = new Request.ListAuditLogEntriesRequest.Kind[]{Request.ListAuditLogEntriesRequest.Kind.forNumber(1), Request.ListAuditLogEntriesRequest.Kind.forNumber(2)};
        private final Integer TAIL__LTE = 1000;
        Pattern LOOKUP__PATTERN = Pattern.compile((String)"^[0123456789ABCDEFGHJKMNPQRSTVWXYZ]{26}$");

        public void assertValid(Request.ListAuditLogEntriesRequest proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.in((String)".cerbos.request.v1.ListAuditLogEntriesRequest.kind", (Object)((Object)proto.getKind()), (Object[])this.KIND__IN);
            switch (proto.getFilterCase()) {
                case TAIL: {
                    ComparativeValidation.lessThanOrEqual((String)".cerbos.request.v1.ListAuditLogEntriesRequest.tail", (Object)proto.getTail(), (Object)this.TAIL__LTE, Comparator.naturalOrder());
                    break;
                }
                case BETWEEN: {
                    if (!proto.hasBetween()) break;
                    index.validatorFor((Object)proto.getBetween()).assertValid((Object)proto.getBetween());
                    break;
                }
                case SINCE: {
                    if (!proto.hasSince()) break;
                    index.validatorFor((Object)proto.getSince()).assertValid((Object)proto.getSince());
                    break;
                }
                case LOOKUP: {
                    StringValidation.pattern((String)".cerbos.request.v1.ListAuditLogEntriesRequest.lookup", (String)proto.getLookup(), (Pattern)this.LOOKUP__PATTERN);
                    break;
                }
                default: {
                    RequiredValidation.required((String)".cerbos.request.v1.ListAuditLogEntriesRequest.filter", null);
                }
            }
        }
    }

    public static class AddOrUpdatePolicyRequestValidator
    implements ValidatorImpl<Request.AddOrUpdatePolicyRequest> {
        public void assertValid(Request.AddOrUpdatePolicyRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.AddOrUpdatePolicyRequest.policies", proto.getPoliciesList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.AddOrUpdatePolicyRequest.policies", proto.getPoliciesList(), (int)10);
            RepeatedValidation.forEach(proto.getPoliciesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PlaygroundProxyRequestValidator
    implements ValidatorImpl<Request.PlaygroundProxyRequest> {
        public void assertValid(Request.PlaygroundProxyRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.PlaygroundProxyRequest.files", proto.getFilesList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.PlaygroundProxyRequest.files", proto.getFilesList(), (int)30);
            RepeatedValidation.forEach(proto.getFilesList(), item -> index.validatorFor(item).assertValid(item));
            switch (proto.getProxyRequestCase()) {
                case CHECK_RESOURCE_SET: {
                    if (!proto.hasCheckResourceSet()) break;
                    index.validatorFor((Object)proto.getCheckResourceSet()).assertValid((Object)proto.getCheckResourceSet());
                    break;
                }
                case CHECK_RESOURCE_BATCH: {
                    if (!proto.hasCheckResourceBatch()) break;
                    index.validatorFor((Object)proto.getCheckResourceBatch()).assertValid((Object)proto.getCheckResourceBatch());
                    break;
                }
                case PLAN_RESOURCES: {
                    if (!proto.hasPlanResources()) break;
                    index.validatorFor((Object)proto.getPlanResources()).assertValid((Object)proto.getPlanResources());
                    break;
                }
                case CHECK_RESOURCES: {
                    if (!proto.hasCheckResources()) break;
                    index.validatorFor((Object)proto.getCheckResources()).assertValid((Object)proto.getCheckResources());
                    break;
                }
                default: {
                    RequiredValidation.required((String)".cerbos.request.v1.PlaygroundProxyRequest.proxy_request", null);
                }
            }
        }
    }

    public static class PlaygroundEvaluateRequestValidator
    implements ValidatorImpl<Request.PlaygroundEvaluateRequest> {
        public void assertValid(Request.PlaygroundEvaluateRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.PlaygroundEvaluateRequest.files", proto.getFilesList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.PlaygroundEvaluateRequest.files", proto.getFilesList(), (int)30);
            RepeatedValidation.forEach(proto.getFilesList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasPrincipal()) {
                RequiredValidation.required((String)".cerbos.request.v1.PlaygroundEvaluateRequest.principal", (GeneratedMessageV3)proto.getPrincipal());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.PlaygroundEvaluateRequest.principal", null);
            }
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            if (proto.hasResource()) {
                RequiredValidation.required((String)".cerbos.request.v1.PlaygroundEvaluateRequest.resource", (GeneratedMessageV3)proto.getResource());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.PlaygroundEvaluateRequest.resource", null);
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
            RepeatedValidation.minItems((String)".cerbos.request.v1.PlaygroundEvaluateRequest.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.PlaygroundEvaluateRequest.actions", (List)proto.getActionsList(), (int)50);
            RepeatedValidation.unique((String)".cerbos.request.v1.PlaygroundEvaluateRequest.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.request.v1.PlaygroundEvaluateRequest.actions", (String)item, (int)1));
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }

    public static class PlaygroundTestRequestValidator
    implements ValidatorImpl<Request.PlaygroundTestRequest> {
        public void assertValid(Request.PlaygroundTestRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.PlaygroundTestRequest.files", proto.getFilesList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.PlaygroundTestRequest.files", proto.getFilesList(), (int)30);
            RepeatedValidation.forEach(proto.getFilesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PlaygroundValidateRequestValidator
    implements ValidatorImpl<Request.PlaygroundValidateRequest> {
        public void assertValid(Request.PlaygroundValidateRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.PlaygroundValidateRequest.files", proto.getFilesList(), (int)1);
            RepeatedValidation.maxItems((String)".cerbos.request.v1.PlaygroundValidateRequest.files", proto.getFilesList(), (int)30);
            RepeatedValidation.forEach(proto.getFilesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class FileValidator
    implements ValidatorImpl<Request.File> {
        public void assertValid(Request.File proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.request.v1.File.file_name", (String)proto.getFileName(), (int)1);
            BytesValidation.minLength((String)".cerbos.request.v1.File.contents", (ByteString)proto.getContents(), (int)1);
            BytesValidation.maxLength((String)".cerbos.request.v1.File.contents", (ByteString)proto.getContents(), (int)0x100000);
        }
    }

    public static class AuxDataValidator
    implements ValidatorImpl<Request.AuxData> {
        public void assertValid(Request.AuxData proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasJwt()) {
                index.validatorFor((Object)proto.getJwt()).assertValid((Object)proto.getJwt());
            }
        }
    }

    public static class CheckResourcesRequestValidator
    implements ValidatorImpl<Request.CheckResourcesRequest> {
        public void assertValid(Request.CheckResourcesRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasPrincipal()) {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourcesRequest.principal", (GeneratedMessageV3)proto.getPrincipal());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourcesRequest.principal", null);
            }
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            RepeatedValidation.minItems((String)".cerbos.request.v1.CheckResourcesRequest.resources", proto.getResourcesList(), (int)1);
            RepeatedValidation.forEach(proto.getResourcesList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }

    public static class CheckResourceBatchRequestValidator
    implements ValidatorImpl<Request.CheckResourceBatchRequest> {
        public void assertValid(Request.CheckResourceBatchRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasPrincipal()) {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceBatchRequest.principal", (GeneratedMessageV3)proto.getPrincipal());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceBatchRequest.principal", null);
            }
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            RepeatedValidation.minItems((String)".cerbos.request.v1.CheckResourceBatchRequest.resources", proto.getResourcesList(), (int)1);
            RepeatedValidation.forEach(proto.getResourcesList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }

    public static class AttributesMapValidator
    implements ValidatorImpl<Request.AttributesMap> {
        public void assertValid(Request.AttributesMap proto, ValidatorIndex index) throws ValidationException {
            MapValidation.noSparse((String)".cerbos.request.v1.AttributesMap.attr", proto.getAttrMap());
            MapValidation.validateParts(proto.getAttrMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getAttrMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class ResourceSetValidator
    implements ValidatorImpl<Request.ResourceSet> {
        Pattern KIND__PATTERN = Pattern.compile((String)"^[[:alpha:]][[:word:]\\@\\.\\-/]*(\\:[[:alpha:]][[:word:]\\@\\.\\-/]*)*$");
        Pattern POLICY_VERSION__PATTERN = Pattern.compile((String)"^[[:word:]]*$");
        Pattern SCOPE__PATTERN = Pattern.compile((String)"^([[:alnum:]][[:word:]\\-]*(\\.[[:word:]\\-]*)*)*$");

        public void assertValid(Request.ResourceSet proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.request.v1.ResourceSet.kind", (String)proto.getKind(), (int)1);
            StringValidation.pattern((String)".cerbos.request.v1.ResourceSet.kind", (String)proto.getKind(), (Pattern)this.KIND__PATTERN);
            StringValidation.pattern((String)".cerbos.request.v1.ResourceSet.policy_version", (String)proto.getPolicyVersion(), (Pattern)this.POLICY_VERSION__PATTERN);
            MapValidation.min((String)".cerbos.request.v1.ResourceSet.instances", proto.getInstancesMap(), (int)1);
            MapValidation.noSparse((String)".cerbos.request.v1.ResourceSet.instances", proto.getInstancesMap());
            MapValidation.validateParts(proto.getInstancesMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getInstancesMap().values(), value -> index.validatorFor(value).assertValid(value));
            StringValidation.pattern((String)".cerbos.request.v1.ResourceSet.scope", (String)proto.getScope(), (Pattern)this.SCOPE__PATTERN);
        }
    }

    public static class CheckResourceSetRequestValidator
    implements ValidatorImpl<Request.CheckResourceSetRequest> {
        public void assertValid(Request.CheckResourceSetRequest proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.request.v1.CheckResourceSetRequest.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.request.v1.CheckResourceSetRequest.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.request.v1.CheckResourceSetRequest.actions", (String)item, (int)1));
            if (proto.hasPrincipal()) {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceSetRequest.principal", (GeneratedMessageV3)proto.getPrincipal());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceSetRequest.principal", null);
            }
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            if (proto.hasResource()) {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceSetRequest.resource", (GeneratedMessageV3)proto.getResource());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.CheckResourceSetRequest.resource", null);
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }

    public static class PlanResourcesRequestValidator
    implements ValidatorImpl<Request.PlanResourcesRequest> {
        public void assertValid(Request.PlanResourcesRequest proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.request.v1.PlanResourcesRequest.action", (String)proto.getAction(), (int)1);
            if (proto.hasPrincipal()) {
                RequiredValidation.required((String)".cerbos.request.v1.PlanResourcesRequest.principal", (GeneratedMessageV3)proto.getPrincipal());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.PlanResourcesRequest.principal", null);
            }
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            if (proto.hasResource()) {
                RequiredValidation.required((String)".cerbos.request.v1.PlanResourcesRequest.resource", (GeneratedMessageV3)proto.getResource());
            } else {
                RequiredValidation.required((String)".cerbos.request.v1.PlanResourcesRequest.resource", null);
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }
}

