/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.api.v1.policy;

import com.google.protobuf.GeneratedMessageV3;
import com.google.re2j.Pattern;
import dev.cerbos.api.v1.effect.EffectOuterClass;
import dev.cerbos.api.v1.policy.PolicyOuterClass;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.MapValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.List;

public class PolicyOuterClassValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(PolicyOuterClass.Policy.class)) {
            return new PolicyValidator();
        }
        if (clazz.equals(PolicyOuterClass.Metadata.class)) {
            return new MetadataValidator();
        }
        if (clazz.equals(PolicyOuterClass.ResourcePolicy.class)) {
            return new ResourcePolicyValidator();
        }
        if (clazz.equals(PolicyOuterClass.ResourceRule.class)) {
            return new ResourceRuleValidator();
        }
        if (clazz.equals(PolicyOuterClass.PrincipalPolicy.class)) {
            return new PrincipalPolicyValidator();
        }
        if (clazz.equals(PolicyOuterClass.PrincipalRule.class)) {
            return new PrincipalRuleValidator();
        }
        if (clazz.equals(PolicyOuterClass.DerivedRoles.class)) {
            return new DerivedRolesValidator();
        }
        if (clazz.equals(PolicyOuterClass.RoleDef.class)) {
            return new RoleDefValidator();
        }
        if (clazz.equals(PolicyOuterClass.ExportVariables.class)) {
            return new ExportVariablesValidator();
        }
        if (clazz.equals(PolicyOuterClass.Variables.class)) {
            return new VariablesValidator();
        }
        if (clazz.equals(PolicyOuterClass.Condition.class)) {
            return new ConditionValidator();
        }
        if (clazz.equals(PolicyOuterClass.Match.class)) {
            return new MatchValidator();
        }
        if (clazz.equals(PolicyOuterClass.Output.class)) {
            return new OutputValidator();
        }
        if (clazz.equals(PolicyOuterClass.Schemas.class)) {
            return new SchemasValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestFixture.class)) {
            return new TestFixtureValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestOptions.class)) {
            return new TestOptionsValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestSuite.class)) {
            return new TestSuiteValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestTable.class)) {
            return new TestTableValidator();
        }
        if (clazz.equals(PolicyOuterClass.Test.class)) {
            return new TestValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.class)) {
            return new TestResultsValidator();
        }
        if (clazz.equals(PolicyOuterClass.PrincipalRule.Action.class)) {
            return new PrincipalRule_ActionValidator();
        }
        if (clazz.equals(PolicyOuterClass.Match.ExprList.class)) {
            return new Match_ExprListValidator();
        }
        if (clazz.equals(PolicyOuterClass.Schemas.IgnoreWhen.class)) {
            return new Schemas_IgnoreWhenValidator();
        }
        if (clazz.equals(PolicyOuterClass.Schemas.Schema.class)) {
            return new Schemas_SchemaValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestFixture.Principals.class)) {
            return new TestFixture_PrincipalsValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestFixture.Resources.class)) {
            return new TestFixture_ResourcesValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestFixture.AuxData.class)) {
            return new TestFixture_AuxDataValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestTable.Input.class)) {
            return new TestTable_InputValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestTable.OutputExpectations.class)) {
            return new TestTable_OutputExpectationsValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestTable.Expectation.class)) {
            return new TestTable_ExpectationValidator();
        }
        if (clazz.equals(PolicyOuterClass.Test.TestName.class)) {
            return new Test_TestNameValidator();
        }
        if (clazz.equals(PolicyOuterClass.Test.OutputEntries.class)) {
            return new Test_OutputEntriesValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Tally.class)) {
            return new TestResults_TallyValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Summary.class)) {
            return new TestResults_SummaryValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Suite.class)) {
            return new TestResults_SuiteValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.TestCase.class)) {
            return new TestResults_TestCaseValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Principal.class)) {
            return new TestResults_PrincipalValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Resource.class)) {
            return new TestResults_ResourceValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Action.class)) {
            return new TestResults_ActionValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Details.class)) {
            return new TestResults_DetailsValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.OutputFailure.class)) {
            return new TestResults_OutputFailureValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.Failure.class)) {
            return new TestResults_FailureValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.OutputFailure.MismatchedValue.class)) {
            return new TestResults_OutputFailure_MismatchedValueValidator();
        }
        if (clazz.equals(PolicyOuterClass.TestResults.OutputFailure.MissingValue.class)) {
            return new TestResults_OutputFailure_MissingValueValidator();
        }
        return null;
    }

    public static class TestResults_OutputFailure_MissingValueValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.OutputFailure.MissingValue> {
        public void assertValid(PolicyOuterClass.TestResults.OutputFailure.MissingValue proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasExpected()) {
                index.validatorFor((Object)proto.getExpected()).assertValid((Object)proto.getExpected());
            }
        }
    }

    public static class TestResults_OutputFailure_MismatchedValueValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.OutputFailure.MismatchedValue> {
        public void assertValid(PolicyOuterClass.TestResults.OutputFailure.MismatchedValue proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasExpected()) {
                index.validatorFor((Object)proto.getExpected()).assertValid((Object)proto.getExpected());
            }
            if (proto.hasActual()) {
                index.validatorFor((Object)proto.getActual()).assertValid((Object)proto.getActual());
            }
        }
    }

    public static class TestResults_FailureValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Failure> {
        public void assertValid(PolicyOuterClass.TestResults.Failure proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getOutputsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestResults_OutputFailureValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.OutputFailure> {
        public void assertValid(PolicyOuterClass.TestResults.OutputFailure proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOutcomeCase()) {
                case MISMATCHED: {
                    if (!proto.hasMismatched()) break;
                    index.validatorFor((Object)proto.getMismatched()).assertValid((Object)proto.getMismatched());
                    break;
                }
                case MISSING: {
                    if (!proto.hasMissing()) break;
                    index.validatorFor((Object)proto.getMissing()).assertValid((Object)proto.getMissing());
                }
            }
        }
    }

    public static class TestResults_DetailsValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Details> {
        public void assertValid(PolicyOuterClass.TestResults.Details proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getEngineTraceList(), item -> index.validatorFor(item).assertValid(item));
            switch (proto.getOutcomeCase()) {
                case FAILURE: {
                    if (!proto.hasFailure()) break;
                    index.validatorFor((Object)proto.getFailure()).assertValid((Object)proto.getFailure());
                    break;
                }
            }
        }
    }

    public static class TestResults_ActionValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Action> {
        public void assertValid(PolicyOuterClass.TestResults.Action proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasDetails()) {
                index.validatorFor((Object)proto.getDetails()).assertValid((Object)proto.getDetails());
            }
        }
    }

    public static class TestResults_ResourceValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Resource> {
        public void assertValid(PolicyOuterClass.TestResults.Resource proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getActionsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestResults_PrincipalValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Principal> {
        public void assertValid(PolicyOuterClass.TestResults.Principal proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getResourcesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestResults_TestCaseValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.TestCase> {
        public void assertValid(PolicyOuterClass.TestResults.TestCase proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getPrincipalsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestResults_SuiteValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Suite> {
        public void assertValid(PolicyOuterClass.TestResults.Suite proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getPrincipalsList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasSummary()) {
                index.validatorFor((Object)proto.getSummary()).assertValid((Object)proto.getSummary());
            }
            RepeatedValidation.forEach(proto.getTestCasesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestResults_SummaryValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Summary> {
        public void assertValid(PolicyOuterClass.TestResults.Summary proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getResultCountsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestResults_TallyValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults.Tally> {
        public void assertValid(PolicyOuterClass.TestResults.Tally proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class Test_OutputEntriesValidator
    implements ValidatorImpl<PolicyOuterClass.Test.OutputEntries> {
        public void assertValid(PolicyOuterClass.Test.OutputEntries proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getEntriesMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getEntriesMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class Test_TestNameValidator
    implements ValidatorImpl<PolicyOuterClass.Test.TestName> {
        public void assertValid(PolicyOuterClass.Test.TestName proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.Test.TestName.test_table_name", (String)proto.getTestTableName(), (int)1);
            StringValidation.minLength((String)".cerbos.policy.v1.Test.TestName.principal_key", (String)proto.getPrincipalKey(), (int)1);
            StringValidation.minLength((String)".cerbos.policy.v1.Test.TestName.resource_key", (String)proto.getResourceKey(), (int)1);
        }
    }

    public static class TestTable_ExpectationValidator
    implements ValidatorImpl<PolicyOuterClass.TestTable.Expectation> {
        public void assertValid(PolicyOuterClass.TestTable.Expectation proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.TestTable.Expectation.principal", (String)proto.getPrincipal(), (int)1);
            StringValidation.minLength((String)".cerbos.policy.v1.TestTable.Expectation.resource", (String)proto.getResource(), (int)1);
            MapValidation.min((String)".cerbos.policy.v1.TestTable.Expectation.actions", proto.getActionsMap(), (int)1);
            MapValidation.validateParts(proto.getActionsMap().keySet(), key -> StringValidation.minLength((String)".cerbos.policy.v1.TestTable.Expectation.actions", (String)key, (int)1));
            MapValidation.validateParts(proto.getActionsMap().values(), value -> {});
            RepeatedValidation.forEach(proto.getOutputsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestTable_OutputExpectationsValidator
    implements ValidatorImpl<PolicyOuterClass.TestTable.OutputExpectations> {
        public void assertValid(PolicyOuterClass.TestTable.OutputExpectations proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.TestTable.OutputExpectations.action", (String)proto.getAction(), (int)1);
            RepeatedValidation.minItems((String)".cerbos.policy.v1.TestTable.OutputExpectations.expected", proto.getExpectedList(), (int)1);
            RepeatedValidation.forEach(proto.getExpectedList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TestTable_InputValidator
    implements ValidatorImpl<PolicyOuterClass.TestTable.Input> {
        public void assertValid(PolicyOuterClass.TestTable.Input proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.policy.v1.TestTable.Input.principals", (List)proto.getPrincipalsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.policy.v1.TestTable.Input.principals", (List)proto.getPrincipalsList());
            RepeatedValidation.forEach((List)proto.getPrincipalsList(), item -> StringValidation.minLength((String)".cerbos.policy.v1.TestTable.Input.principals", (String)item, (int)1));
            RepeatedValidation.minItems((String)".cerbos.policy.v1.TestTable.Input.resources", (List)proto.getResourcesList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.policy.v1.TestTable.Input.resources", (List)proto.getResourcesList());
            RepeatedValidation.forEach((List)proto.getResourcesList(), item -> StringValidation.minLength((String)".cerbos.policy.v1.TestTable.Input.resources", (String)item, (int)1));
            RepeatedValidation.minItems((String)".cerbos.policy.v1.TestTable.Input.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.policy.v1.TestTable.Input.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.policy.v1.TestTable.Input.actions", (String)item, (int)1));
        }
    }

    public static class TestFixture_AuxDataValidator
    implements ValidatorImpl<PolicyOuterClass.TestFixture.AuxData> {
        public void assertValid(PolicyOuterClass.TestFixture.AuxData proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getAuxDataMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getAuxDataMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class TestFixture_ResourcesValidator
    implements ValidatorImpl<PolicyOuterClass.TestFixture.Resources> {
        public void assertValid(PolicyOuterClass.TestFixture.Resources proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getResourcesMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getResourcesMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class TestFixture_PrincipalsValidator
    implements ValidatorImpl<PolicyOuterClass.TestFixture.Principals> {
        public void assertValid(PolicyOuterClass.TestFixture.Principals proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getPrincipalsMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getPrincipalsMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class Schemas_SchemaValidator
    implements ValidatorImpl<PolicyOuterClass.Schemas.Schema> {
        public void assertValid(PolicyOuterClass.Schemas.Schema proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.Schemas.Schema.ref", (String)proto.getRef(), (int)1);
            if (proto.hasIgnoreWhen()) {
                index.validatorFor((Object)proto.getIgnoreWhen()).assertValid((Object)proto.getIgnoreWhen());
            }
        }
    }

    public static class Schemas_IgnoreWhenValidator
    implements ValidatorImpl<PolicyOuterClass.Schemas.IgnoreWhen> {
        public void assertValid(PolicyOuterClass.Schemas.IgnoreWhen proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.policy.v1.Schemas.IgnoreWhen.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.policy.v1.Schemas.IgnoreWhen.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.policy.v1.Schemas.IgnoreWhen.actions", (String)item, (int)1));
        }
    }

    public static class Match_ExprListValidator
    implements ValidatorImpl<PolicyOuterClass.Match.ExprList> {
        public void assertValid(PolicyOuterClass.Match.ExprList proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.policy.v1.Match.ExprList.of", proto.getOfList(), (int)1);
            RepeatedValidation.forEach(proto.getOfList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PrincipalRule_ActionValidator
    implements ValidatorImpl<PolicyOuterClass.PrincipalRule.Action> {
        private final EffectOuterClass.Effect[] EFFECT__IN = new EffectOuterClass.Effect[]{EffectOuterClass.Effect.forNumber(1), EffectOuterClass.Effect.forNumber(2)};
        Pattern NAME__PATTERN = Pattern.compile((String)"^([[:alpha:]][[:word:]\\@\\.\\-]*)*$");

        public void assertValid(PolicyOuterClass.PrincipalRule.Action proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.PrincipalRule.Action.action", (String)proto.getAction(), (int)1);
            if (proto.hasCondition()) {
                index.validatorFor((Object)proto.getCondition()).assertValid((Object)proto.getCondition());
            }
            CollectiveValidation.in((String)".cerbos.policy.v1.PrincipalRule.Action.effect", (Object)((Object)proto.getEffect()), (Object[])this.EFFECT__IN);
            StringValidation.pattern((String)".cerbos.policy.v1.PrincipalRule.Action.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
            if (proto.hasOutput()) {
                index.validatorFor((Object)proto.getOutput()).assertValid((Object)proto.getOutput());
            }
        }
    }

    public static class TestResultsValidator
    implements ValidatorImpl<PolicyOuterClass.TestResults> {
        public void assertValid(PolicyOuterClass.TestResults proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getSuitesList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasSummary()) {
                index.validatorFor((Object)proto.getSummary()).assertValid((Object)proto.getSummary());
            }
        }
    }

    public static class TestValidator
    implements ValidatorImpl<PolicyOuterClass.Test> {
        public void assertValid(PolicyOuterClass.Test proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasName()) {
                RequiredValidation.required((String)".cerbos.policy.v1.Test.name", (GeneratedMessageV3)proto.getName());
            } else {
                RequiredValidation.required((String)".cerbos.policy.v1.Test.name", null);
            }
            if (proto.hasName()) {
                index.validatorFor((Object)proto.getName()).assertValid((Object)proto.getName());
            }
            if (proto.hasInput()) {
                RequiredValidation.required((String)".cerbos.policy.v1.Test.input", (GeneratedMessageV3)proto.getInput());
            } else {
                RequiredValidation.required((String)".cerbos.policy.v1.Test.input", null);
            }
            if (proto.hasInput()) {
                index.validatorFor((Object)proto.getInput()).assertValid((Object)proto.getInput());
            }
            MapValidation.min((String)".cerbos.policy.v1.Test.expected", proto.getExpectedMap(), (int)1);
            MapValidation.validateParts(proto.getExpectedMap().keySet(), key -> StringValidation.minLength((String)".cerbos.policy.v1.Test.expected", (String)key, (int)1));
            MapValidation.validateParts(proto.getExpectedMap().values(), value -> {});
            if (proto.hasOptions()) {
                index.validatorFor((Object)proto.getOptions()).assertValid((Object)proto.getOptions());
            }
            MapValidation.validateParts(proto.getExpectedOutputsMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getExpectedOutputsMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class TestTableValidator
    implements ValidatorImpl<PolicyOuterClass.TestTable> {
        public void assertValid(PolicyOuterClass.TestTable proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.TestTable.name", (String)proto.getName(), (int)1);
            if (proto.hasInput()) {
                RequiredValidation.required((String)".cerbos.policy.v1.TestTable.input", (GeneratedMessageV3)proto.getInput());
            } else {
                RequiredValidation.required((String)".cerbos.policy.v1.TestTable.input", null);
            }
            if (proto.hasInput()) {
                index.validatorFor((Object)proto.getInput()).assertValid((Object)proto.getInput());
            }
            RepeatedValidation.minItems((String)".cerbos.policy.v1.TestTable.expected", proto.getExpectedList(), (int)1);
            RepeatedValidation.forEach(proto.getExpectedList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasOptions()) {
                index.validatorFor((Object)proto.getOptions()).assertValid((Object)proto.getOptions());
            }
        }
    }

    public static class TestSuiteValidator
    implements ValidatorImpl<PolicyOuterClass.TestSuite> {
        public void assertValid(PolicyOuterClass.TestSuite proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.TestSuite.name", (String)proto.getName(), (int)1);
            RepeatedValidation.minItems((String)".cerbos.policy.v1.TestSuite.tests", proto.getTestsList(), (int)1);
            RepeatedValidation.forEach(proto.getTestsList(), item -> index.validatorFor(item).assertValid(item));
            MapValidation.validateParts(proto.getPrincipalsMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getPrincipalsMap().values(), value -> index.validatorFor(value).assertValid(value));
            MapValidation.validateParts(proto.getResourcesMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getResourcesMap().values(), value -> index.validatorFor(value).assertValid(value));
            MapValidation.validateParts(proto.getAuxDataMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getAuxDataMap().values(), value -> index.validatorFor(value).assertValid(value));
            if (proto.hasOptions()) {
                index.validatorFor((Object)proto.getOptions()).assertValid((Object)proto.getOptions());
            }
        }
    }

    public static class TestOptionsValidator
    implements ValidatorImpl<PolicyOuterClass.TestOptions> {
        public void assertValid(PolicyOuterClass.TestOptions proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasNow()) {
                index.validatorFor((Object)proto.getNow()).assertValid((Object)proto.getNow());
            }
        }
    }

    public static class TestFixtureValidator
    implements ValidatorImpl<PolicyOuterClass.TestFixture> {
        public void assertValid(PolicyOuterClass.TestFixture proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class SchemasValidator
    implements ValidatorImpl<PolicyOuterClass.Schemas> {
        public void assertValid(PolicyOuterClass.Schemas proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasPrincipalSchema()) {
                index.validatorFor((Object)proto.getPrincipalSchema()).assertValid((Object)proto.getPrincipalSchema());
            }
            if (proto.hasResourceSchema()) {
                index.validatorFor((Object)proto.getResourceSchema()).assertValid((Object)proto.getResourceSchema());
            }
        }
    }

    public static class OutputValidator
    implements ValidatorImpl<PolicyOuterClass.Output> {
        public void assertValid(PolicyOuterClass.Output proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class MatchValidator
    implements ValidatorImpl<PolicyOuterClass.Match> {
        public void assertValid(PolicyOuterClass.Match proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getOpCase()) {
                case ALL: {
                    if (!proto.hasAll()) break;
                    index.validatorFor((Object)proto.getAll()).assertValid((Object)proto.getAll());
                    break;
                }
                case ANY: {
                    if (!proto.hasAny()) break;
                    index.validatorFor((Object)proto.getAny()).assertValid((Object)proto.getAny());
                    break;
                }
                case NONE: {
                    if (!proto.hasNone()) break;
                    index.validatorFor((Object)proto.getNone()).assertValid((Object)proto.getNone());
                    break;
                }
                case EXPR: {
                    break;
                }
                default: {
                    RequiredValidation.required((String)".cerbos.policy.v1.Match.op", null);
                }
            }
        }
    }

    public static class ConditionValidator
    implements ValidatorImpl<PolicyOuterClass.Condition> {
        public void assertValid(PolicyOuterClass.Condition proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getConditionCase()) {
                case MATCH: {
                    if (!proto.hasMatch()) break;
                    index.validatorFor((Object)proto.getMatch()).assertValid((Object)proto.getMatch());
                    break;
                }
                case SCRIPT: {
                    break;
                }
                default: {
                    RequiredValidation.required((String)".cerbos.policy.v1.Condition.condition", null);
                }
            }
        }
    }

    public static class VariablesValidator
    implements ValidatorImpl<PolicyOuterClass.Variables> {
        Pattern IMPORT__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");

        public void assertValid(PolicyOuterClass.Variables proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.unique((String)".cerbos.policy.v1.Variables.import", (List)proto.getImportList());
            RepeatedValidation.forEach((List)proto.getImportList(), item -> StringValidation.pattern((String)".cerbos.policy.v1.Variables.import", (String)item, (Pattern)this.IMPORT__PATTERN));
        }
    }

    public static class ExportVariablesValidator
    implements ValidatorImpl<PolicyOuterClass.ExportVariables> {
        Pattern NAME__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");

        public void assertValid(PolicyOuterClass.ExportVariables proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.ExportVariables.name", (String)proto.getName(), (int)1);
            StringValidation.pattern((String)".cerbos.policy.v1.ExportVariables.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
        }
    }

    public static class RoleDefValidator
    implements ValidatorImpl<PolicyOuterClass.RoleDef> {
        Pattern NAME__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");
        Pattern PARENT_ROLES__PATTERN = Pattern.compile((String)"^([[:word:]\\-\\.]+|\\*)$");

        public void assertValid(PolicyOuterClass.RoleDef proto, ValidatorIndex index) throws ValidationException {
            StringValidation.pattern((String)".cerbos.policy.v1.RoleDef.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
            RepeatedValidation.minItems((String)".cerbos.policy.v1.RoleDef.parent_roles", (List)proto.getParentRolesList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.policy.v1.RoleDef.parent_roles", (List)proto.getParentRolesList());
            RepeatedValidation.forEach((List)proto.getParentRolesList(), item -> StringValidation.pattern((String)".cerbos.policy.v1.RoleDef.parent_roles", (String)item, (Pattern)this.PARENT_ROLES__PATTERN));
            if (proto.hasCondition()) {
                index.validatorFor((Object)proto.getCondition()).assertValid((Object)proto.getCondition());
            }
        }
    }

    public static class DerivedRolesValidator
    implements ValidatorImpl<PolicyOuterClass.DerivedRoles> {
        Pattern NAME__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");

        public void assertValid(PolicyOuterClass.DerivedRoles proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.DerivedRoles.name", (String)proto.getName(), (int)1);
            StringValidation.pattern((String)".cerbos.policy.v1.DerivedRoles.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
            RepeatedValidation.minItems((String)".cerbos.policy.v1.DerivedRoles.definitions", proto.getDefinitionsList(), (int)1);
            RepeatedValidation.forEach(proto.getDefinitionsList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasVariables()) {
                index.validatorFor((Object)proto.getVariables()).assertValid((Object)proto.getVariables());
            }
        }
    }

    public static class PrincipalRuleValidator
    implements ValidatorImpl<PolicyOuterClass.PrincipalRule> {
        public void assertValid(PolicyOuterClass.PrincipalRule proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.PrincipalRule.resource", (String)proto.getResource(), (int)1);
            RepeatedValidation.minItems((String)".cerbos.policy.v1.PrincipalRule.actions", proto.getActionsList(), (int)1);
            RepeatedValidation.forEach(proto.getActionsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PrincipalPolicyValidator
    implements ValidatorImpl<PolicyOuterClass.PrincipalPolicy> {
        Pattern PRINCIPAL__PATTERN = Pattern.compile((String)"^[[:alpha:]][[:word:]\\@\\.\\-]*(\\:[[:alpha:]][[:word:]\\@\\.\\-]*)*$");
        Pattern VERSION__PATTERN = Pattern.compile((String)"^[[:word:]]+$");
        Pattern SCOPE__PATTERN = Pattern.compile((String)"^([[:alnum:]][[:word:]\\-]*(\\.[[:word:]\\-]*)*)*$");

        public void assertValid(PolicyOuterClass.PrincipalPolicy proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.PrincipalPolicy.principal", (String)proto.getPrincipal(), (int)1);
            StringValidation.pattern((String)".cerbos.policy.v1.PrincipalPolicy.principal", (String)proto.getPrincipal(), (Pattern)this.PRINCIPAL__PATTERN);
            StringValidation.pattern((String)".cerbos.policy.v1.PrincipalPolicy.version", (String)proto.getVersion(), (Pattern)this.VERSION__PATTERN);
            RepeatedValidation.forEach(proto.getRulesList(), item -> index.validatorFor(item).assertValid(item));
            StringValidation.pattern((String)".cerbos.policy.v1.PrincipalPolicy.scope", (String)proto.getScope(), (Pattern)this.SCOPE__PATTERN);
            if (proto.hasVariables()) {
                index.validatorFor((Object)proto.getVariables()).assertValid((Object)proto.getVariables());
            }
        }
    }

    public static class ResourceRuleValidator
    implements ValidatorImpl<PolicyOuterClass.ResourceRule> {
        Pattern DERIVED_ROLES__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");
        Pattern ROLES__PATTERN = Pattern.compile((String)"^([[:word:]\\-\\.]+|\\*)$");
        private final EffectOuterClass.Effect[] EFFECT__IN = new EffectOuterClass.Effect[]{EffectOuterClass.Effect.forNumber(1), EffectOuterClass.Effect.forNumber(2)};
        Pattern NAME__PATTERN = Pattern.compile((String)"^([[:alpha:]][[:word:]\\@\\.\\-]*)*$");

        public void assertValid(PolicyOuterClass.ResourceRule proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".cerbos.policy.v1.ResourceRule.actions", (List)proto.getActionsList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.policy.v1.ResourceRule.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.policy.v1.ResourceRule.actions", (String)item, (int)1));
            RepeatedValidation.unique((String)".cerbos.policy.v1.ResourceRule.derived_roles", (List)proto.getDerivedRolesList());
            RepeatedValidation.forEach((List)proto.getDerivedRolesList(), item -> StringValidation.pattern((String)".cerbos.policy.v1.ResourceRule.derived_roles", (String)item, (Pattern)this.DERIVED_ROLES__PATTERN));
            RepeatedValidation.unique((String)".cerbos.policy.v1.ResourceRule.roles", (List)proto.getRolesList());
            RepeatedValidation.forEach((List)proto.getRolesList(), item -> StringValidation.pattern((String)".cerbos.policy.v1.ResourceRule.roles", (String)item, (Pattern)this.ROLES__PATTERN));
            if (proto.hasCondition()) {
                index.validatorFor((Object)proto.getCondition()).assertValid((Object)proto.getCondition());
            }
            CollectiveValidation.in((String)".cerbos.policy.v1.ResourceRule.effect", (Object)((Object)proto.getEffect()), (Object[])this.EFFECT__IN);
            StringValidation.pattern((String)".cerbos.policy.v1.ResourceRule.name", (String)proto.getName(), (Pattern)this.NAME__PATTERN);
            if (proto.hasOutput()) {
                index.validatorFor((Object)proto.getOutput()).assertValid((Object)proto.getOutput());
            }
        }
    }

    public static class ResourcePolicyValidator
    implements ValidatorImpl<PolicyOuterClass.ResourcePolicy> {
        Pattern RESOURCE__PATTERN = Pattern.compile((String)"^[[:alpha:]][[:word:]\\@\\.\\-/]*(\\:[[:alpha:]][[:word:]\\@\\.\\-/]*)*$");
        Pattern VERSION__PATTERN = Pattern.compile((String)"^[[:word:]]+$");
        Pattern IMPORT_DERIVED_ROLES__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");
        Pattern SCOPE__PATTERN = Pattern.compile((String)"^([[:alnum:]][[:word:]\\-]*(\\.[[:word:]\\-]*)*)*$");

        public void assertValid(PolicyOuterClass.ResourcePolicy proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.policy.v1.ResourcePolicy.resource", (String)proto.getResource(), (int)1);
            StringValidation.pattern((String)".cerbos.policy.v1.ResourcePolicy.resource", (String)proto.getResource(), (Pattern)this.RESOURCE__PATTERN);
            StringValidation.pattern((String)".cerbos.policy.v1.ResourcePolicy.version", (String)proto.getVersion(), (Pattern)this.VERSION__PATTERN);
            RepeatedValidation.unique((String)".cerbos.policy.v1.ResourcePolicy.import_derived_roles", (List)proto.getImportDerivedRolesList());
            RepeatedValidation.forEach((List)proto.getImportDerivedRolesList(), item -> StringValidation.pattern((String)".cerbos.policy.v1.ResourcePolicy.import_derived_roles", (String)item, (Pattern)this.IMPORT_DERIVED_ROLES__PATTERN));
            RepeatedValidation.forEach(proto.getRulesList(), item -> index.validatorFor(item).assertValid(item));
            StringValidation.pattern((String)".cerbos.policy.v1.ResourcePolicy.scope", (String)proto.getScope(), (Pattern)this.SCOPE__PATTERN);
            if (proto.hasSchemas()) {
                index.validatorFor((Object)proto.getSchemas()).assertValid((Object)proto.getSchemas());
            }
            if (proto.hasVariables()) {
                index.validatorFor((Object)proto.getVariables()).assertValid((Object)proto.getVariables());
            }
        }
    }

    public static class MetadataValidator
    implements ValidatorImpl<PolicyOuterClass.Metadata> {
        public void assertValid(PolicyOuterClass.Metadata proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasHash()) {
                index.validatorFor((Object)proto.getHash()).assertValid((Object)proto.getHash());
            }
        }
    }

    public static class PolicyValidator
    implements ValidatorImpl<PolicyOuterClass.Policy> {
        public void assertValid(PolicyOuterClass.Policy proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".cerbos.policy.v1.Policy.api_version", (Object)proto.getApiVersion(), (Object)"api.cerbos.dev/v1");
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            switch (proto.getPolicyTypeCase()) {
                case RESOURCE_POLICY: {
                    if (!proto.hasResourcePolicy()) break;
                    index.validatorFor((Object)proto.getResourcePolicy()).assertValid((Object)proto.getResourcePolicy());
                    break;
                }
                case PRINCIPAL_POLICY: {
                    if (!proto.hasPrincipalPolicy()) break;
                    index.validatorFor((Object)proto.getPrincipalPolicy()).assertValid((Object)proto.getPrincipalPolicy());
                    break;
                }
                case DERIVED_ROLES: {
                    if (!proto.hasDerivedRoles()) break;
                    index.validatorFor((Object)proto.getDerivedRoles()).assertValid((Object)proto.getDerivedRoles());
                    break;
                }
                case EXPORT_VARIABLES: {
                    if (!proto.hasExportVariables()) break;
                    index.validatorFor((Object)proto.getExportVariables()).assertValid((Object)proto.getExportVariables());
                    break;
                }
                default: {
                    RequiredValidation.required((String)".cerbos.policy.v1.Policy.policy_type", null);
                }
            }
        }
    }
}

