/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.api.v1.engine;

import com.google.protobuf.GeneratedMessageV3;
import com.google.re2j.Pattern;
import dev.cerbos.api.v1.engine.Engine;
import io.envoyproxy.pgv.MapValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.List;

public class EngineValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Engine.PlanResourcesInput.class)) {
            return new PlanResourcesInputValidator();
        }
        if (clazz.equals(Engine.PlanResourcesAst.class)) {
            return new PlanResourcesAstValidator();
        }
        if (clazz.equals(Engine.PlanResourcesFilter.class)) {
            return new PlanResourcesFilterValidator();
        }
        if (clazz.equals(Engine.PlanResourcesOutput.class)) {
            return new PlanResourcesOutputValidator();
        }
        if (clazz.equals(Engine.CheckInput.class)) {
            return new CheckInputValidator();
        }
        if (clazz.equals(Engine.CheckOutput.class)) {
            return new CheckOutputValidator();
        }
        if (clazz.equals(Engine.OutputEntry.class)) {
            return new OutputEntryValidator();
        }
        if (clazz.equals(Engine.Resource.class)) {
            return new ResourceValidator();
        }
        if (clazz.equals(Engine.Principal.class)) {
            return new PrincipalValidator();
        }
        if (clazz.equals(Engine.AuxData.class)) {
            return new AuxDataValidator();
        }
        if (clazz.equals(Engine.Trace.class)) {
            return new TraceValidator();
        }
        if (clazz.equals(Engine.PlanResourcesInput.Resource.class)) {
            return new PlanResourcesInput_ResourceValidator();
        }
        if (clazz.equals(Engine.PlanResourcesAst.Node.class)) {
            return new PlanResourcesAst_NodeValidator();
        }
        if (clazz.equals(Engine.PlanResourcesAst.LogicalOperation.class)) {
            return new PlanResourcesAst_LogicalOperationValidator();
        }
        if (clazz.equals(Engine.PlanResourcesFilter.Expression.class)) {
            return new PlanResourcesFilter_ExpressionValidator();
        }
        if (clazz.equals(Engine.PlanResourcesFilter.Expression.Operand.class)) {
            return new PlanResourcesFilter_Expression_OperandValidator();
        }
        if (clazz.equals(Engine.CheckOutput.ActionEffect.class)) {
            return new CheckOutput_ActionEffectValidator();
        }
        if (clazz.equals(Engine.Trace.Component.class)) {
            return new Trace_ComponentValidator();
        }
        if (clazz.equals(Engine.Trace.Event.class)) {
            return new Trace_EventValidator();
        }
        if (clazz.equals(Engine.Trace.Component.Variable.class)) {
            return new Trace_Component_VariableValidator();
        }
        return null;
    }

    public static class Trace_Component_VariableValidator
    implements ValidatorImpl<Engine.Trace.Component.Variable> {
        public void assertValid(Engine.Trace.Component.Variable proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class Trace_EventValidator
    implements ValidatorImpl<Engine.Trace.Event> {
        public void assertValid(Engine.Trace.Event proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasResult()) {
                index.validatorFor((Object)proto.getResult()).assertValid((Object)proto.getResult());
            }
        }
    }

    public static class Trace_ComponentValidator
    implements ValidatorImpl<Engine.Trace.Component> {
        public void assertValid(Engine.Trace.Component proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getDetailsCase()) {
                case ACTION: {
                    break;
                }
                case DERIVED_ROLE: {
                    break;
                }
                case EXPR: {
                    break;
                }
                case INDEX: {
                    break;
                }
                case POLICY: {
                    break;
                }
                case RESOURCE: {
                    break;
                }
                case RULE: {
                    break;
                }
                case SCOPE: {
                    break;
                }
                case VARIABLE: {
                    if (!proto.hasVariable()) break;
                    index.validatorFor((Object)proto.getVariable()).assertValid((Object)proto.getVariable());
                    break;
                }
            }
        }
    }

    public static class CheckOutput_ActionEffectValidator
    implements ValidatorImpl<Engine.CheckOutput.ActionEffect> {
        public void assertValid(Engine.CheckOutput.ActionEffect proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class PlanResourcesFilter_Expression_OperandValidator
    implements ValidatorImpl<Engine.PlanResourcesFilter.Expression.Operand> {
        public void assertValid(Engine.PlanResourcesFilter.Expression.Operand proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getNodeCase()) {
                case VALUE: {
                    if (!proto.hasValue()) break;
                    index.validatorFor((Object)proto.getValue()).assertValid((Object)proto.getValue());
                    break;
                }
                case EXPRESSION: {
                    if (!proto.hasExpression()) break;
                    index.validatorFor((Object)proto.getExpression()).assertValid((Object)proto.getExpression());
                    break;
                }
            }
        }
    }

    public static class PlanResourcesFilter_ExpressionValidator
    implements ValidatorImpl<Engine.PlanResourcesFilter.Expression> {
        public void assertValid(Engine.PlanResourcesFilter.Expression proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getOperandsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PlanResourcesAst_LogicalOperationValidator
    implements ValidatorImpl<Engine.PlanResourcesAst.LogicalOperation> {
        public void assertValid(Engine.PlanResourcesAst.LogicalOperation proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getNodesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PlanResourcesAst_NodeValidator
    implements ValidatorImpl<Engine.PlanResourcesAst.Node> {
        public void assertValid(Engine.PlanResourcesAst.Node proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getNodeCase()) {
                case LOGICAL_OPERATION: {
                    if (!proto.hasLogicalOperation()) break;
                    index.validatorFor((Object)proto.getLogicalOperation()).assertValid((Object)proto.getLogicalOperation());
                    break;
                }
                case EXPRESSION: {
                    if (!proto.hasExpression()) break;
                    index.validatorFor((Object)proto.getExpression()).assertValid((Object)proto.getExpression());
                }
            }
        }
    }

    public static class PlanResourcesInput_ResourceValidator
    implements ValidatorImpl<Engine.PlanResourcesInput.Resource> {
        Pattern KIND__PATTERN = Pattern.compile((String)"^[[:alpha:]][[:word:]\\@\\.\\-/]*(\\:[[:alpha:]][[:word:]\\@\\.\\-/]*)*$");
        Pattern POLICY_VERSION__PATTERN = Pattern.compile((String)"^[[:word:]]*$");
        Pattern SCOPE__PATTERN = Pattern.compile((String)"^([[:alnum:]][[:word:]\\-]*(\\.[[:word:]\\-]*)*)*$");

        public void assertValid(Engine.PlanResourcesInput.Resource proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.engine.v1.PlanResourcesInput.Resource.kind", (String)proto.getKind(), (int)1);
            StringValidation.pattern((String)".cerbos.engine.v1.PlanResourcesInput.Resource.kind", (String)proto.getKind(), (Pattern)this.KIND__PATTERN);
            MapValidation.noSparse((String)".cerbos.engine.v1.PlanResourcesInput.Resource.attr", proto.getAttrMap());
            MapValidation.validateParts(proto.getAttrMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getAttrMap().values(), value -> index.validatorFor(value).assertValid(value));
            StringValidation.pattern((String)".cerbos.engine.v1.PlanResourcesInput.Resource.policy_version", (String)proto.getPolicyVersion(), (Pattern)this.POLICY_VERSION__PATTERN);
            StringValidation.pattern((String)".cerbos.engine.v1.PlanResourcesInput.Resource.scope", (String)proto.getScope(), (Pattern)this.SCOPE__PATTERN);
        }
    }

    public static class TraceValidator
    implements ValidatorImpl<Engine.Trace> {
        public void assertValid(Engine.Trace proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getComponentsList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasEvent()) {
                index.validatorFor((Object)proto.getEvent()).assertValid((Object)proto.getEvent());
            }
        }
    }

    public static class AuxDataValidator
    implements ValidatorImpl<Engine.AuxData> {
        public void assertValid(Engine.AuxData proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getJwtMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getJwtMap().values(), value -> index.validatorFor(value).assertValid(value));
        }
    }

    public static class PrincipalValidator
    implements ValidatorImpl<Engine.Principal> {
        Pattern POLICY_VERSION__PATTERN = Pattern.compile((String)"^[[:word:]]*$");
        Pattern ROLES__PATTERN = Pattern.compile((String)"^[[:word:]\\-\\.]+$");
        Pattern SCOPE__PATTERN = Pattern.compile((String)"^([[:alnum:]][[:word:]\\-]*(\\.[[:word:]\\-]*)*)*$");

        public void assertValid(Engine.Principal proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.engine.v1.Principal.id", (String)proto.getId(), (int)1);
            StringValidation.pattern((String)".cerbos.engine.v1.Principal.policy_version", (String)proto.getPolicyVersion(), (Pattern)this.POLICY_VERSION__PATTERN);
            RepeatedValidation.minItems((String)".cerbos.engine.v1.Principal.roles", (List)proto.getRolesList(), (int)1);
            RepeatedValidation.unique((String)".cerbos.engine.v1.Principal.roles", (List)proto.getRolesList());
            RepeatedValidation.forEach((List)proto.getRolesList(), item -> StringValidation.pattern((String)".cerbos.engine.v1.Principal.roles", (String)item, (Pattern)this.ROLES__PATTERN));
            MapValidation.noSparse((String)".cerbos.engine.v1.Principal.attr", proto.getAttrMap());
            MapValidation.validateParts(proto.getAttrMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getAttrMap().values(), value -> index.validatorFor(value).assertValid(value));
            StringValidation.pattern((String)".cerbos.engine.v1.Principal.scope", (String)proto.getScope(), (Pattern)this.SCOPE__PATTERN);
        }
    }

    public static class ResourceValidator
    implements ValidatorImpl<Engine.Resource> {
        Pattern KIND__PATTERN = Pattern.compile((String)"^[[:alpha:]][[:word:]\\@\\.\\-/]*(\\:[[:alpha:]][[:word:]\\@\\.\\-/]*)*$");
        Pattern POLICY_VERSION__PATTERN = Pattern.compile((String)"^[[:word:]]*$");
        Pattern SCOPE__PATTERN = Pattern.compile((String)"^([[:alnum:]][[:word:]\\-]*(\\.[[:word:]\\-]*)*)*$");

        public void assertValid(Engine.Resource proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.engine.v1.Resource.kind", (String)proto.getKind(), (int)1);
            StringValidation.pattern((String)".cerbos.engine.v1.Resource.kind", (String)proto.getKind(), (Pattern)this.KIND__PATTERN);
            StringValidation.pattern((String)".cerbos.engine.v1.Resource.policy_version", (String)proto.getPolicyVersion(), (Pattern)this.POLICY_VERSION__PATTERN);
            StringValidation.minLength((String)".cerbos.engine.v1.Resource.id", (String)proto.getId(), (int)1);
            MapValidation.noSparse((String)".cerbos.engine.v1.Resource.attr", proto.getAttrMap());
            MapValidation.validateParts(proto.getAttrMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getAttrMap().values(), value -> index.validatorFor(value).assertValid(value));
            StringValidation.pattern((String)".cerbos.engine.v1.Resource.scope", (String)proto.getScope(), (Pattern)this.SCOPE__PATTERN);
        }
    }

    public static class OutputEntryValidator
    implements ValidatorImpl<Engine.OutputEntry> {
        public void assertValid(Engine.OutputEntry proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class CheckOutputValidator
    implements ValidatorImpl<Engine.CheckOutput> {
        public void assertValid(Engine.CheckOutput proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getActionsMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getActionsMap().values(), value -> index.validatorFor(value).assertValid(value));
            RepeatedValidation.forEach((List)proto.getEffectiveDerivedRolesList(), item -> {});
            RepeatedValidation.forEach(proto.getValidationErrorsList(), item -> index.validatorFor(item).assertValid(item));
            RepeatedValidation.forEach(proto.getOutputsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class CheckInputValidator
    implements ValidatorImpl<Engine.CheckInput> {
        public void assertValid(Engine.CheckInput proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasResource()) {
                RequiredValidation.required((String)".cerbos.engine.v1.CheckInput.resource", (GeneratedMessageV3)proto.getResource());
            } else {
                RequiredValidation.required((String)".cerbos.engine.v1.CheckInput.resource", null);
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
            if (proto.hasPrincipal()) {
                RequiredValidation.required((String)".cerbos.engine.v1.CheckInput.principal", (GeneratedMessageV3)proto.getPrincipal());
            } else {
                RequiredValidation.required((String)".cerbos.engine.v1.CheckInput.principal", null);
            }
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            RepeatedValidation.unique((String)".cerbos.engine.v1.CheckInput.actions", (List)proto.getActionsList());
            RepeatedValidation.forEach((List)proto.getActionsList(), item -> StringValidation.minLength((String)".cerbos.engine.v1.CheckInput.actions", (String)item, (int)1));
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }

    public static class PlanResourcesOutputValidator
    implements ValidatorImpl<Engine.PlanResourcesOutput> {
        public void assertValid(Engine.PlanResourcesOutput proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasFilter()) {
                index.validatorFor((Object)proto.getFilter()).assertValid((Object)proto.getFilter());
            }
            RepeatedValidation.forEach(proto.getValidationErrorsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class PlanResourcesFilterValidator
    implements ValidatorImpl<Engine.PlanResourcesFilter> {
        public void assertValid(Engine.PlanResourcesFilter proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasCondition()) {
                index.validatorFor((Object)proto.getCondition()).assertValid((Object)proto.getCondition());
            }
        }
    }

    public static class PlanResourcesAstValidator
    implements ValidatorImpl<Engine.PlanResourcesAst> {
        public void assertValid(Engine.PlanResourcesAst proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasFilterAst()) {
                index.validatorFor((Object)proto.getFilterAst()).assertValid((Object)proto.getFilterAst());
            }
        }
    }

    public static class PlanResourcesInputValidator
    implements ValidatorImpl<Engine.PlanResourcesInput> {
        public void assertValid(Engine.PlanResourcesInput proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasPrincipal()) {
                index.validatorFor((Object)proto.getPrincipal()).assertValid((Object)proto.getPrincipal());
            }
            if (proto.hasResource()) {
                index.validatorFor((Object)proto.getResource()).assertValid((Object)proto.getResource());
            }
            if (proto.hasAuxData()) {
                index.validatorFor((Object)proto.getAuxData()).assertValid((Object)proto.getAuxData());
            }
        }
    }
}

