/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import com.google.protobuf.Value;
import dev.cerbos.api.v1.effect.EffectOuterClass;
import dev.cerbos.api.v1.engine.Engine;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.api.v1.schema.SchemaOuterClass;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class CheckResult {
    private final Response.CheckResourcesResponse.ResultEntry entry;

    CheckResult(Response.CheckResourcesResponse.ResultEntry entry) {
        this.entry = entry;
    }

    public boolean isAllowed(String action) {
        if (this.entry == null) {
            return false;
        }
        return this.entry.getActionsMap().getOrDefault(action, EffectOuterClass.Effect.EFFECT_DENY) == EffectOuterClass.Effect.EFFECT_ALLOW;
    }

    public Map<String, Boolean> getAll() {
        if (this.entry == null) {
            return Collections.emptyMap();
        }
        return this.entry.getActionsMap().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> e.getValue() == EffectOuterClass.Effect.EFFECT_ALLOW));
    }

    public boolean hasValidationErrors() {
        if (this.entry == null) {
            return false;
        }
        return this.entry.getValidationErrorsCount() > 0;
    }

    public List<SchemaOuterClass.ValidationError> getValidationErrors() {
        if (this.entry == null) {
            return Collections.emptyList();
        }
        return this.entry.getValidationErrorsList();
    }

    public Meta getMeta() {
        return new Meta(this.entry.getMeta());
    }

    public Outputs getOutputs() {
        return new Outputs(this.entry.getOutputsList());
    }

    public Optional<Response.CheckResourcesResponse.ResultEntry> getRaw() {
        return Optional.ofNullable(this.entry);
    }

    public static final class Outputs {
        private final List<Engine.OutputEntry> outputs;

        Outputs(List<Engine.OutputEntry> outputs) {
            this.outputs = outputs;
        }

        public int size() {
            return this.outputs.size();
        }

        public Map<String, Value> asMap() {
            return this.outputs.stream().collect(Collectors.toUnmodifiableMap(Engine.OutputEntry::getSrc, Engine.OutputEntry::getVal));
        }

        public List<Engine.OutputEntry> getRaw() {
            return this.outputs;
        }
    }

    public static final class Meta {
        private final Response.CheckResourcesResponse.ResultEntry.Meta meta;

        Meta(Response.CheckResourcesResponse.ResultEntry.Meta meta) {
            this.meta = meta;
        }

        public List<String> getEffectiveDerivedRoles() {
            return this.meta.getEffectiveDerivedRolesList().stream().collect(Collectors.toUnmodifiableList());
        }

        public Optional<Response.CheckResourcesResponse.ResultEntry.Meta.EffectMeta> getInfoForAction(String action) {
            if (this.meta.containsActions(action)) {
                return Optional.of(this.meta.getActionsOrThrow(action));
            }
            return Optional.empty();
        }

        public Map<String, Response.CheckResourcesResponse.ResultEntry.Meta.EffectMeta> getActionsMap() {
            return this.meta.getActionsMap();
        }

        public Response.CheckResourcesResponse.ResultEntry.Meta getRaw() {
            return this.meta;
        }
    }
}

