/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.api.v1.schema;

import com.google.protobuf.ByteString;
import dev.cerbos.api.v1.schema.SchemaOuterClass;
import io.envoyproxy.pgv.BytesValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;

public class SchemaOuterClassValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(SchemaOuterClass.ValidationError.class)) {
            return new ValidationErrorValidator();
        }
        if (clazz.equals(SchemaOuterClass.Schema.class)) {
            return new SchemaValidator();
        }
        return null;
    }

    public static class SchemaValidator
    implements ValidatorImpl<SchemaOuterClass.Schema> {
        public void assertValid(SchemaOuterClass.Schema proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".cerbos.schema.v1.Schema.id", (String)proto.getId(), (int)1);
            StringValidation.maxLength((String)".cerbos.schema.v1.Schema.id", (String)proto.getId(), (int)255);
            BytesValidation.minLength((String)".cerbos.schema.v1.Schema.definition", (ByteString)proto.getDefinition(), (int)10);
        }
    }

    public static class ValidationErrorValidator
    implements ValidatorImpl<SchemaOuterClass.ValidationError> {
        public void assertValid(SchemaOuterClass.ValidationError proto, ValidatorIndex index) throws ValidationException {
        }
    }
}

